/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.common.tables;

import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.tables.TablePrefixStatementUpdater;
import org.jobrunr.utils.StringUtils;

public class AnsiDatabaseTablePrefixStatementUpdater
implements TablePrefixStatementUpdater {
    protected final String tablePrefix;
    protected final String indexPrefix;

    public AnsiDatabaseTablePrefixStatementUpdater(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        this.indexPrefix = this.getIndexPrefix(tablePrefix);
    }

    @Override
    public String updateStatement(String statement) {
        if (this.isIndexStatement(statement)) {
            return this.updateStatementWithTablePrefixForIndexStatement(statement);
        }
        return this.updateStatementWithTablePrefixForOtherStatements(statement);
    }

    @Override
    public String getFQTableName(String tableName) {
        return StorageProviderUtils.elementPrefixer(this.tablePrefix, tableName);
    }

    private boolean isIndexStatement(String statement) {
        return statement.contains("CREATE INDEX ") || statement.contains("CREATE UNIQUE INDEX ") || statement.contains("DROP INDEX ");
    }

    protected String updateStatementWithTablePrefixForIndexStatement(String statement) {
        String updatedStatement = statement.toUpperCase().contains(" ON ") ? statement.replace("CREATE UNIQUE INDEX jobrunr_", "CREATE UNIQUE INDEX " + StorageProviderUtils.elementPrefixer(this.indexPrefix, "jobrunr_")).replace("CREATE INDEX jobrunr_", "CREATE INDEX " + StorageProviderUtils.elementPrefixer(this.indexPrefix, "jobrunr_")).replace("DROP INDEX jobrunr_", "DROP INDEX " + StorageProviderUtils.elementPrefixer(this.indexPrefix, "jobrunr_")).replace("ON jobrunr_", "ON " + StorageProviderUtils.elementPrefixer(this.tablePrefix, "jobrunr_")) : statement.replace("CREATE UNIQUE INDEX jobrunr_", "CREATE UNIQUE INDEX " + StorageProviderUtils.elementPrefixer(this.indexPrefix, "jobrunr_")).replace("CREATE INDEX jobrunr_", "CREATE INDEX " + StorageProviderUtils.elementPrefixer(this.indexPrefix, "jobrunr_")).replace("DROP INDEX jobrunr_", "DROP INDEX " + StorageProviderUtils.elementPrefixer(this.tablePrefix, "jobrunr_"));
        return updatedStatement;
    }

    private String updateStatementWithTablePrefixForOtherStatements(String statement) {
        return statement.replace("jobrunr_", StorageProviderUtils.elementPrefixer(this.tablePrefix, "jobrunr_"));
    }

    private String getIndexPrefix(String tablePrefix) {
        return StringUtils.substringAfterLast(tablePrefix, ".");
    }
}

