/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.storage.sql.mysql;

import java.time.Instant;
import javax.sql.DataSource;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.DefaultSqlStorageProvider;
import org.jobrunr.storage.sql.common.db.dialect.AnsiDialect;
import org.jobrunr.storage.sql.common.db.dialect.Dialect;
import org.jobrunr.utils.exceptions.Exceptions;

public class MySqlStorageProvider
extends DefaultSqlStorageProvider {
    public MySqlStorageProvider(DataSource dataSource) {
        this(dataSource, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public MySqlStorageProvider(DataSource dataSource, String tablePrefix) {
        this(dataSource, tablePrefix, StorageProviderUtils.DatabaseOptions.CREATE);
    }

    public MySqlStorageProvider(DataSource dataSource, StorageProviderUtils.DatabaseOptions databaseOptions) {
        this(dataSource, (String)null, databaseOptions);
    }

    public MySqlStorageProvider(DataSource dataSource, String tablePrefix, StorageProviderUtils.DatabaseOptions databaseOptions) {
        super(dataSource, (Dialect)new AnsiDialect(), tablePrefix, databaseOptions);
    }

    @Override
    public void announceBackgroundJobServer(BackgroundJobServerStatus serverStatus) {
        Exceptions.retryOnException(() -> super.announceBackgroundJobServer(serverStatus), 5);
    }

    @Override
    public int removeTimedOutBackgroundJobServers(Instant heartbeatOlderThan) {
        return Exceptions.retryOnException(() -> super.removeTimedOutBackgroundJobServers(heartbeatOlderThan), 5);
    }

    @Override
    public boolean signalBackgroundJobServerAlive(BackgroundJobServerStatus serverStatus) {
        return Exceptions.retryOnException(() -> super.signalBackgroundJobServerAlive(serverStatus), 5);
    }

    @Override
    public void signalBackgroundJobServerStopped(BackgroundJobServerStatus serverStatus) {
        Exceptions.retryOnException(() -> super.signalBackgroundJobServerStopped(serverStatus), 5);
    }
}

