/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.annotations.Job;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.scheduling.exceptions.JobClassNotFoundException;
import org.jobrunr.scheduling.exceptions.JobMethodNotFoundException;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobUtils {
    private JobUtils() {
    }

    public static String getReadableNameFromJobDetails(JobDetails jobDetails) {
        String result = JobUtils.getJobClassAndMethodName(jobDetails);
        result = result + "(" + jobDetails.getJobParameters().stream().map(JobUtils::getJobParameterValue).collect(Collectors.joining(",")) + ")";
        return result;
    }

    public static Class<?> getJobClass(JobDetails jobDetails) {
        try {
            return ReflectionUtils.toClass(jobDetails.getClassName());
        }
        catch (IllegalArgumentException e) {
            throw new JobClassNotFoundException(jobDetails);
        }
    }

    public static Method getJobMethod(JobDetails jobDetails) {
        return JobUtils.getJobMethod(JobUtils.getJobClass(jobDetails), jobDetails);
    }

    public static Method getJobMethod(Class<?> jobClass, JobDetails jobDetails) {
        return ReflectionUtils.findMethod(jobClass, jobDetails.getMethodName(), jobDetails.getJobParameterTypes()).orElseThrow(() -> new JobMethodNotFoundException(jobDetails));
    }

    public static void assertJobExists(JobDetails jobDetails) {
        if (!jobDetails.hasStaticFieldName() && JobUtils.getJobMethod(jobDetails) == null) {
            throw new IllegalStateException("Job does not exist");
        }
    }

    public static boolean jobExists(String jobSignature) {
        if (jobSignature.startsWith("java.") || jobSignature.startsWith("javax.")) {
            return true;
        }
        try {
            String clazzAndMethod = JobUtils.getFQClassNameAndMethod(jobSignature);
            String clazzName = JobUtils.getFQClassName(clazzAndMethod);
            String method = JobUtils.getMethodName(clazzAndMethod);
            Class clazz = ReflectionUtils.toClass(clazzName);
            Class<?>[] jobParameterTypes = JobUtils.getParameterTypes(jobSignature);
            return ReflectionUtils.findMethod(clazz, method, jobParameterTypes).isPresent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Optional<Job> getJobAnnotation(JobDetails jobDetails) {
        return (Optional)ReflectionUtils.cast(JobUtils.getJobAnnotations(jobDetails).filter(jobAnnotation -> jobAnnotation.annotationType().equals(Job.class)).findFirst());
    }

    public static String getJobSignature(org.jobrunr.jobs.Job job) {
        return JobUtils.getJobSignature(job.getJobDetails());
    }

    public static String getJobSignature(JobDetails jobDetails) {
        String result = JobUtils.getJobClassAndMethodName(jobDetails);
        result = result + "(" + jobDetails.getJobParameters().stream().map(JobUtils::getJobParameterForSignature).collect(Collectors.joining(",")) + ")";
        return result;
    }

    private static Stream<Annotation> getJobAnnotations(JobDetails jobDetails) {
        if (jobDetails.getClassName().startsWith("java")) {
            return Stream.empty();
        }
        Method jobMethod = JobUtils.getJobMethod(jobDetails);
        return Stream.of(jobMethod.getDeclaredAnnotations());
    }

    private static String getFQClassNameAndMethod(String jobSignature) {
        return jobSignature.substring(0, jobSignature.indexOf("("));
    }

    private static String getFQClassName(String clazzAndMethod) {
        return clazzAndMethod.substring(0, clazzAndMethod.lastIndexOf("."));
    }

    private static String getMethodName(String clazzAndMethod) {
        return clazzAndMethod.substring(clazzAndMethod.lastIndexOf(".") + 1);
    }

    private static Class<?>[] getParameterTypes(String jobSignature) {
        String jobParameterTypesAsString = jobSignature.substring(jobSignature.indexOf("(") + 1, jobSignature.length() - 1);
        if (jobParameterTypesAsString.replaceAll("\\s", "").isEmpty()) {
            return new Class[0];
        }
        Class[] jobParameterTypes = (Class[])Arrays.stream(jobParameterTypesAsString.split(",")).map(ReflectionUtils::toClass).toArray(Class[]::new);
        return jobParameterTypes;
    }

    private static String getJobParameterForSignature(JobParameter jobParameter) {
        return jobParameter.getObject() != null ? jobParameter.getObject().getClass().getName() : jobParameter.getClassName();
    }

    private static String getJobClassAndMethodName(JobDetails jobDetails) {
        String result = jobDetails.getClassName();
        Optional<String> staticFieldName = Optional.ofNullable(jobDetails.getStaticFieldName());
        if (staticFieldName.isPresent()) {
            result = result + "." + staticFieldName.get();
        }
        result = result + "." + jobDetails.getMethodName();
        return result;
    }

    private static String getJobParameterValue(JobParameter jobParameter) {
        if (jobParameter.getClassName().equals(JobContext.class.getName())) {
            return JobContext.class.getSimpleName();
        }
        return jobParameter.getObject().toString();
    }
}

