/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RuntimeClassNameTypeAdapterFactory<T>
implements TypeAdapterFactory {
    public static final String TYPE_FIELD_NAME = "@class";
    private final Class<?> baseType;
    private final String typeFieldName;
    private final Map<String, Class<?>> labelToSubtype = new LinkedHashMap();
    private final Map<Class<?>, String> subtypeToLabel = new LinkedHashMap();

    private RuntimeClassNameTypeAdapterFactory(Class<?> baseType, String typeFieldName) {
        if (typeFieldName == null || baseType == null) {
            throw new NullPointerException();
        }
        this.baseType = baseType;
        this.typeFieldName = typeFieldName;
    }

    public static <T> RuntimeClassNameTypeAdapterFactory<T> of(Class<T> baseType, String typeFieldName) {
        return new RuntimeClassNameTypeAdapterFactory<T>(baseType, typeFieldName);
    }

    public static <T> RuntimeClassNameTypeAdapterFactory<T> of(Class<T> baseType) {
        return new RuntimeClassNameTypeAdapterFactory<T>(baseType, TYPE_FIELD_NAME);
    }

    public RuntimeClassNameTypeAdapterFactory<T> registerSubtype(Class<? extends T> type, String label) {
        if (type == null || label == null) {
            throw new NullPointerException();
        }
        if (this.subtypeToLabel.containsKey(type) || this.labelToSubtype.containsKey(label)) {
            throw new IllegalArgumentException("types and labels must be unique");
        }
        this.labelToSubtype.put(label, type);
        this.subtypeToLabel.put(type, label);
        return this;
    }

    public RuntimeClassNameTypeAdapterFactory<T> registerSubtype(Class<? extends T> type) {
        return this.registerSubtype(type, type.getSimpleName());
    }

    public <R> TypeAdapter<R> create(final Gson gson, final TypeToken<R> type) {
        final LinkedHashMap<String, TypeAdapter> labelToDelegate = new LinkedHashMap<String, TypeAdapter>();
        final LinkedHashMap<Class, TypeAdapter> subtypeToDelegate = new LinkedHashMap<Class, TypeAdapter>();
        if (Object.class.isAssignableFrom(type.getRawType())) {
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            labelToDelegate.put(type.getRawType().getName(), delegate);
            subtypeToDelegate.put(type.getRawType(), delegate);
        }
        return new TypeAdapter<R>(){

            public R read(JsonReader in) {
                JsonElement jsonElement = Streams.parse((JsonReader)in);
                if (jsonElement.isJsonObject() && ((JsonObject)jsonElement).has(RuntimeClassNameTypeAdapterFactory.this.typeFieldName)) {
                    JsonElement labelJsonElement = jsonElement.getAsJsonObject().remove(RuntimeClassNameTypeAdapterFactory.this.typeFieldName);
                    if (labelJsonElement == null) {
                        throw new JsonParseException("cannot deserialize " + RuntimeClassNameTypeAdapterFactory.this.baseType + " because it does not define a field named " + RuntimeClassNameTypeAdapterFactory.this.typeFieldName);
                    }
                    String label = labelJsonElement.getAsString();
                    TypeAdapter delegate = (TypeAdapter)labelToDelegate.get(label);
                    if (delegate == null) {
                        Class<?> aClass;
                        try {
                            aClass = Class.forName(label);
                        }
                        catch (ClassNotFoundException e) {
                            throw new JsonParseException("Cannot find class " + label, (Throwable)e);
                        }
                        TypeToken subClass = TypeToken.get(aClass);
                        delegate = gson.getDelegateAdapter((TypeAdapterFactory)RuntimeClassNameTypeAdapterFactory.this, subClass);
                        if (delegate == null) {
                            throw new JsonParseException("cannot deserialize " + RuntimeClassNameTypeAdapterFactory.this.baseType + " subtype named " + label + "; did you forget to register a subtype?");
                        }
                    }
                    return delegate.fromJsonTree(jsonElement);
                }
                if (jsonElement.isJsonNull()) {
                    return null;
                }
                TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)RuntimeClassNameTypeAdapterFactory.this, type);
                if (delegate == null) {
                    throw new JsonParseException("cannot deserialize " + RuntimeClassNameTypeAdapterFactory.this.baseType + "; did you forget to register a subtype?");
                }
                return delegate.fromJsonTree(jsonElement);
            }

            public void write(JsonWriter out, R value) throws IOException {
                Class<?> srcType = value.getClass();
                String label = srcType.getName();
                TypeAdapter delegate = this.getDelegate(srcType);
                if (delegate == null) {
                    throw new JsonParseException("cannot serialize " + srcType.getName() + "; did you forget to register a subtype?");
                }
                JsonElement jsonTree = delegate.toJsonTree(value);
                if (!jsonTree.isJsonObject()) {
                    Streams.write((JsonElement)jsonTree, (JsonWriter)out);
                } else {
                    JsonObject jsonObject = jsonTree.getAsJsonObject();
                    if (RuntimeClassNameTypeAdapterFactory.this.baseType.isAssignableFrom(srcType)) {
                        if (jsonObject.has(RuntimeClassNameTypeAdapterFactory.this.typeFieldName)) {
                            throw new JsonParseException("cannot serialize " + srcType.getName() + " because it already defines a field named " + RuntimeClassNameTypeAdapterFactory.this.typeFieldName);
                        }
                        JsonObject clone = new JsonObject();
                        clone.add(RuntimeClassNameTypeAdapterFactory.this.typeFieldName, (JsonElement)new JsonPrimitive(label));
                        for (Map.Entry e : jsonObject.entrySet()) {
                            clone.add((String)e.getKey(), (JsonElement)e.getValue());
                        }
                        Streams.write((JsonElement)clone, (JsonWriter)out);
                    } else {
                        Streams.write((JsonElement)jsonObject, (JsonWriter)out);
                    }
                }
            }

            private TypeAdapter<R> getDelegate(Class<?> srcType) {
                TypeAdapter typeAdapter = (TypeAdapter)subtypeToDelegate.get(srcType);
                if (typeAdapter != null) {
                    return typeAdapter;
                }
                for (Map.Entry classTypeAdapterEntry : subtypeToDelegate.entrySet()) {
                    if (!((Class)classTypeAdapterEntry.getKey()).isAssignableFrom(srcType)) continue;
                    return (TypeAdapter)classTypeAdapterEntry.getValue();
                }
                return null;
            }
        }.nullSafe();
    }
}

