/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.mapper.jsonb.adapters;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.adapter.JsonbAdapter;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.JobParameterNotDeserializableException;
import org.jobrunr.utils.mapper.JobParameterJsonMapperException;
import org.jobrunr.utils.mapper.JsonMapperUtils;
import org.jobrunr.utils.mapper.jsonb.JobRunrJsonb;
import org.jobrunr.utils.mapper.jsonb.NullSafeJsonBuilder;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobDetailsAdapter
implements JsonbAdapter<JobDetails, JsonObject> {
    private final JobRunrJsonb jsonb;

    public JobDetailsAdapter(JobRunrJsonb jsonb) {
        this.jsonb = jsonb;
    }

    public JsonObject adaptToJson(JobDetails jobDetails) throws Exception {
        JsonArrayBuilder parametersJsonArray = Json.createArrayBuilder();
        try {
            for (JobParameter jobState : jobDetails.getJobParameters()) {
                JsonObject object = NullSafeJsonBuilder.nullSafeJsonObjectBuilder(this.jsonb, jobState).build();
                parametersJsonArray.add((JsonValue)object);
            }
        }
        catch (Exception e) {
            throw new JobParameterJsonMapperException("The job parameters are not serializable.", e);
        }
        return NullSafeJsonBuilder.nullSafeJsonObjectBuilder().add("cacheable", jobDetails.getCacheable()).add("className", jobDetails.getClassName()).add("staticFieldName", jobDetails.getStaticFieldName()).add("methodName", jobDetails.getMethodName()).add("jobParameters", (JsonValue)parametersJsonArray.build()).build();
    }

    public JobDetails adaptFromJson(JsonObject jsonObject) throws Exception {
        JobDetails jobDetails = new JobDetails(jsonObject.getString("className"), jsonObject.isNull("staticFieldName") ? null : jsonObject.getString("staticFieldName"), jsonObject.getString("methodName"), this.getJobDetailsParameters(jsonObject.getJsonArray("jobParameters")));
        jobDetails.setCacheable(jsonObject.getBoolean("cacheable"));
        return jobDetails;
    }

    private List<JobParameter> getJobDetailsParameters(JsonArray jobParameters) {
        ArrayList<JobParameter> result = new ArrayList<JobParameter>();
        for (JsonValue jsonValue : jobParameters) {
            JsonObject jsonObject = jsonValue.asJsonObject();
            String methodClassName = jsonObject.getString("className");
            String actualClassName = jsonObject.getString("actualClassName", null);
            try {
                Object object = this.jsonb.fromJsonValue((JsonValue)jsonObject.get((Object)"object"), ReflectionUtils.toClass(JsonMapperUtils.getActualClassName(methodClassName, actualClassName)));
                result.add(new JobParameter(methodClassName, object));
            }
            catch (Exception e) {
                result.add(new JobParameter(new JobParameterNotDeserializableException(JsonMapperUtils.getActualClassName(methodClassName, actualClassName), e.getMessage())));
            }
        }
        return result;
    }
}

