/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.reflection.autobox;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.reflection.autobox.InstantForOracleTypeAutoboxer;
import org.jobrunr.utils.reflection.autobox.TypeAutoboxer;

public class InstantTypeAutoboxer
implements TypeAutoboxer<Instant> {
    @Override
    public boolean supports(Class<?> type) {
        return Instant.class.equals(type);
    }

    @Override
    public Instant autobox(Object value, Class<Instant> type) {
        if (value instanceof Timestamp) {
            return (Instant)ReflectionUtils.cast(((Timestamp)value).toInstant());
        }
        if (value instanceof Long) {
            return (Instant)ReflectionUtils.cast(new Timestamp((Long)value).toInstant());
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant();
        }
        if ("oracle.sql.TIMESTAMP".equals(value.getClass().getName())) {
            return new InstantForOracleTypeAutoboxer().autobox(value, (Class)type);
        }
        if (value instanceof CharSequence) {
            return Instant.parse((CharSequence)value);
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Instant.class.getName()));
    }
}

