/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.reflection.autobox;

import java.sql.Clob;
import java.sql.SQLException;
import org.jobrunr.JobRunrException;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.jobrunr.utils.reflection.autobox.TypeAutoboxer;

public class StringTypeAutoboxer
implements TypeAutoboxer<String> {
    @Override
    public boolean supports(Class<?> type) {
        return String.class.equals(type);
    }

    @Override
    public String autobox(Object value, Class<String> type) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Clob) {
            try {
                Clob clob = (Clob)value;
                return (String)ReflectionUtils.cast(clob.getSubString(1L, (int)clob.length()));
            }
            catch (SQLException e) {
                throw JobRunrException.shouldNotHappenException(e);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), String.class.getName()));
    }
}

