/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.resilience;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jobrunr.utils.resilience.Lock;
import org.jobrunr.utils.resilience.Lockable;

public class MultiLock
implements Closeable {
    private final Collection<Lock> locks;

    public MultiLock(Lockable ... lockables) {
        this(Arrays.asList(lockables));
    }

    public MultiLock(Collection<? extends Lockable> lockables) {
        this.locks = lockables.parallelStream().map(Lockable::lock).collect(Collectors.toList());
    }

    public void unlock() {
        this.locks.forEach(Lock::unlock);
    }

    @Override
    public void close() {
        this.unlock();
    }
}

