/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.resources;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.HashMap;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.resources.FileSystemProvider;

public class ResourcesFileSystemProvider
implements FileSystemProvider {
    private FileSystem fileSystem;

    @Override
    public Path toPath(URI uri) throws IOException {
        try {
            if (!"resource".equals(uri.getScheme())) {
                throw new IllegalArgumentException("ResourcesFileSystemProvider only supports uri's starting with resource:");
            }
            FileSystem fs = this.getFileSystem();
            return fs.getPath(StringUtils.substringAfter(uri.toString(), ":"), new String[0]);
        }
        catch (ProviderNotFoundException e) {
            throw new ProviderNotFoundException("Provider not found for URI " + uri);
        }
    }

    private FileSystem getFileSystem() throws IOException {
        if (this.fileSystem == null) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("create", Boolean.TRUE);
            this.fileSystem = FileSystems.newFileSystem(URI.create("resource:/resources"), options, null);
        }
        return this.fileSystem;
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
    }
}

