/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.utils.streams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

class BatchCollector<T>
implements Collector<T, List<T>, List<T>> {
    private final int batchSize;
    private final Consumer<List<T>> batchProcessor;

    BatchCollector(int batchSize, Consumer<List<T>> batchProcessor) {
        this.batchSize = batchSize;
        this.batchProcessor = Objects.requireNonNull(batchProcessor);
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return (ts, t) -> {
            ts.add(t);
            if (ts.size() >= this.batchSize) {
                this.batchProcessor.accept((List<List>)ts);
                ts.clear();
            }
        };
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (ts, ots) -> {
            this.batchProcessor.accept((List<List>)ts);
            this.batchProcessor.accept((List<List>)ots);
            return Collections.emptyList();
        };
    }

    @Override
    public Function<List<T>, List<T>> finisher() {
        return ts -> {
            this.batchProcessor.accept((List<List>)ts);
            return Collections.emptyList();
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

