import { RegistryOptions } from './registry';
/**
 * Publishes an extension.
 */
export declare function publish(options?: PublishOptions): Promise<PromiseSettledResult<void>[]>;
interface PublishCommonOptions extends RegistryOptions {
    /**
     * Path to the vsix file to be published. Cannot be used together with `packagePath`.
     */
    extensionFile?: string;
    /**
     * The base URL for links detected in Markdown files. Only valid with `packagePath`.
     */
    baseContentUrl?: string;
    /**
     * The base URL for images detected in Markdown files. Only valid with `packagePath`.
     */
    baseImagesUrl?: string;
    /**
     * Should use `yarn` instead of `npm`. Only valid with `packagePath`.
     */
    yarn?: boolean;
    /**
     * Mark this package as a pre-release. Only valid with `packagePath`.
     */
    preRelease?: boolean;
    /**
     * Whether to fail silently if version already exists on the marketplace
     */
    skipDuplicate?: boolean;
}
export interface PublishOptions extends PublishCommonOptions {
    /**
     * Target architectures.
     */
    targets?: string[];
    /**
     * Paths to the extension to be packaged and published. Cannot be used together
     * with `extensionFile`.
     */
    packagePath?: string[];
    /**
     * Whether to do dependency detection via npm or yarn
     */
    dependencies?: boolean;
}
export {};
//# sourceMappingURL=publish.d.ts.map