/********************************************************************************
 * Copyright (c) 2019 TypeFox and others
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 ********************************************************************************/
/// <reference types="node" />
import * as http from 'http';
export declare const DEFAULT_URL = "https://open-vsx.org";
export declare const DEFAULT_NAMESPACE_SIZE = 1024;
export declare const DEFAULT_PUBLISH_SIZE: number;
export declare class Registry {
    readonly url: string;
    readonly maxNamespaceSize: number;
    readonly maxPublishSize: number;
    readonly username?: string;
    readonly password?: string;
    constructor(options?: RegistryOptions);
    get requiresLicense(): boolean;
    createNamespace(name: string, pat: string): Promise<Response>;
    verifyPat(namespace: string, pat: string): Promise<Response>;
    publish(file: string, pat: string): Promise<Extension>;
    getMetadata(namespace: string, extension: string, target?: string): Promise<Extension>;
    download(file: string, url: URL): Promise<void>;
    getJson<T extends Response>(url: URL): Promise<T>;
    post<T extends Response>(content: string | Buffer | Uint8Array, url: URL, headers?: http.OutgoingHttpHeaders, maxBodyLength?: number): Promise<T>;
    postFile<T extends Response>(file: string, url: URL, headers?: http.OutgoingHttpHeaders, maxBodyLength?: number): Promise<T>;
    private getUrl;
    private getProtocol;
    private getRequestOptions;
    private getJsonResponse;
}
export interface RegistryOptions {
    /**
     * The base URL of the registry API.
     */
    registryUrl?: string;
    /**
     * Personal access token.
     */
    pat?: string;
    /**
     * User name for basic authentication.
     */
    username?: string;
    /**
     * Password for basic authentication.
     */
    password?: string;
    /**
     * Maximal request body size for creating namespaces.
     */
    maxNamespaceSize?: number;
    /**
     * Maximal request body size for publishing.
     */
    maxPublishSize?: number;
}
export interface Response {
    success?: string;
    warning?: string;
    error?: string;
}
export interface Extension extends Response {
    namespaceUrl: string;
    reviewsUrl: string;
    files: {
        [type: string]: string;
    };
    name: string;
    namespace: string;
    version: string;
    targetPlatform: string;
    publishedBy: UserData;
    verified: boolean;
    allVersions: {
        [version: string]: string;
    };
    averageRating?: number;
    downloadCount: number;
    reviewCount: number;
    versionAlias: string[];
    timestamp: string;
    preview?: boolean;
    displayName?: string;
    description?: string;
    engines?: {
        [engine: string]: string;
    };
    categories?: string[];
    tags?: string[];
    license?: string;
    homepage?: string;
    repository?: string;
    bugs?: string;
    markdown?: string;
    galleryColor?: string;
    galleryTheme?: string;
    qna?: string;
    badges?: Badge[];
    dependencies?: ExtensionReference[];
    bundledExtensions?: ExtensionReference[];
}
export interface UserData {
    loginName: string;
    fullName?: string;
    avatarUrl?: string;
    homepage?: string;
}
export interface Badge {
    url: string;
    href: string;
    description: string;
}
export interface ExtensionReference {
    url: string;
    namespace: string;
    extension: string;
    version?: string;
}
export interface ErrorResponse {
    error: string;
    message: string;
    status: number;
    path?: string;
    timestamp?: string;
    trace?: string;
}
//# sourceMappingURL=registry.d.ts.map