/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.QueryCheckException;
import org.apache.jena.sparql.lang.SPARQLParserRegistry;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.sparql.sse.WriterSSE;
import org.apache.jena.sparql.sse.builders.BuildException;

public class QueryUtils {
    public static void checkQuery(Query query, boolean optimizeAlgebra) {
        QueryUtils.checkParse(query);
        QueryUtils.checkOp(query, optimizeAlgebra);
    }

    public static void checkOp(Query query, boolean optimizeAlgebra) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        Op op = Algebra.compile(query);
        if (optimizeAlgebra) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out((IndentedWriter)buff, op, (Prologue)query);
        String str2 = buff.toString();
        try {
            Op op2 = SSE.parseOp(str2);
            if (op.hashCode() != op2.hashCode()) {
                op.hashCode();
                op2.hashCode();
                QueryUtils.dump(op, op2);
                throw new QueryCheckException("reparsed algebra expression hashCode does not equal algebra from query");
            }
            if (!op.equals(op2)) {
                QueryUtils.dump(op, op2);
                throw new QueryCheckException("reparsed algebra expression does not equal query algebra");
            }
        }
        catch (SSEParseException | BuildException ex) {
            System.err.println(str2);
            throw ex;
        }
    }

    private static void dump(Op op, Op op2) {
        System.err.println("***********");
        System.err.println(op);
        System.err.println(op2);
        System.err.println("***********");
    }

    public static void checkParse(Query query) {
        if (!SPARQLParserRegistry.get().containsFactory(query.getSyntax())) {
            return;
        }
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query.serialize(buff, query.getSyntax());
        String tmp = buff.toString();
        Query query2 = null;
        try {
            String baseURI = null;
            if (!query.explicitlySetBaseURI()) {
                baseURI = query.getBaseURI();
            }
            if ((query2 = QueryFactory.create(tmp, baseURI, query.getSyntax())) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            System.err.println(tmp);
            throw new QueryCheckException("could not parse output query", (Throwable)((Object)ex));
        }
        if (query.hashCode() != query2.hashCode()) {
            throw new QueryCheckException("reparsed query hashCode does not equal parsed input query \nQuery (hashCode: " + query.hashCode() + ")=\n" + query + "\n\nQuery2 (hashCode: " + query2.hashCode() + ")=\n" + query2);
        }
        if (!query.equals(query2)) {
            throw new QueryCheckException("reparsed output does not equal parsed input");
        }
    }
}

