/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.FutureResult;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record10;
import org.jooq.Record11;
import org.jooq.Record12;
import org.jooq.Record13;
import org.jooq.Record14;
import org.jooq.Record15;
import org.jooq.Record16;
import org.jooq.Record17;
import org.jooq.Record18;
import org.jooq.Record19;
import org.jooq.Record2;
import org.jooq.Record20;
import org.jooq.Record21;
import org.jooq.Record22;
import org.jooq.Record3;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Record7;
import org.jooq.Record8;
import org.jooq.Record9;
import org.jooq.RecordHandler;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Results;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.ExecutorProviderCompletionStage;
import org.jooq.impl.FutureResultImpl;
import org.jooq.impl.Intern;
import org.jooq.impl.Limit;
import org.jooq.impl.R2DBC;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.SelectQueryImpl;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.jdbc.MockResultSet;
import org.reactivestreams.Subscriber;

abstract class AbstractResultQuery<R extends Record>
extends AbstractQuery
implements ResultQuery<R> {
    private static final long serialVersionUID = -5588344253566055707L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractResultQuery.class);
    private static final Set<SQLDialect> REPORT_FETCH_SIZE_WITH_AUTOCOMMIT = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private int maxRows;
    private int fetchSize;
    private int resultSetConcurrency;
    private int resultSetType;
    private int resultSetHoldability;
    private Table<?> coerceTable;
    private Collection<? extends Field<?>> coerceFields;
    private transient boolean lazy;
    private transient boolean many;
    private transient Cursor<R> cursor;
    private transient boolean autoclosing = true;
    private Result<R> result;
    private ResultsImpl results;
    private final Intern intern = new Intern();

    AbstractResultQuery(Configuration configuration) {
        super(configuration);
    }

    protected abstract Field<?>[] getFields(ResultSetMetaData var1) throws SQLException;

    @Override
    public final ResultQuery<R> bind(String param, Object value) {
        return (ResultQuery)super.bind(param, value);
    }

    @Override
    public final ResultQuery<R> bind(int index, Object value) {
        return (ResultQuery)super.bind(index, value);
    }

    @Override
    public final ResultQuery<R> poolable(boolean poolable) {
        return (ResultQuery)super.poolable(poolable);
    }

    @Override
    public final ResultQuery<R> queryTimeout(int timeout) {
        return (ResultQuery)super.queryTimeout(timeout);
    }

    @Override
    public final ResultQuery<R> keepStatement(boolean k) {
        return (ResultQuery)super.keepStatement(k);
    }

    @Override
    public final ResultQuery<R> maxRows(int rows) {
        this.maxRows = rows;
        return this;
    }

    @Override
    public final ResultQuery<R> fetchSize(int rows) {
        this.fetchSize = rows;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetConcurrency(int concurrency) {
        this.resultSetConcurrency = concurrency;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetType(int type) {
        this.resultSetType = type;
        return this;
    }

    @Override
    public final ResultQuery<R> resultSetHoldability(int holdability) {
        this.resultSetHoldability = holdability;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(Field<?> ... fields) {
        this.intern.internFields = fields;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(int ... fieldIndexes) {
        this.intern.internIndexes = fieldIndexes;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(String ... fieldNameStrings) {
        this.intern.internNameStrings = fieldNameStrings;
        return this;
    }

    @Override
    public final ResultQuery<R> intern(Name ... fieldNames) {
        this.intern.internNames = fieldNames;
        return this;
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        if (ctx.statement() == null) {
            if (this.resultSetConcurrency != 0 || this.resultSetType != 0 || this.resultSetHoldability != 0) {
                int concurrency;
                int type = this.resultSetType != 0 ? this.resultSetType : 1003;
                int n = concurrency = this.resultSetConcurrency != 0 ? this.resultSetConcurrency : 1007;
                if (this.resultSetHoldability == 0) {
                    ctx.statement(ctx.connection().prepareStatement(ctx.sql(), type, concurrency));
                } else {
                    ctx.statement(ctx.connection().prepareStatement(ctx.sql(), type, concurrency, this.resultSetHoldability));
                }
            } else {
                ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
            }
        }
        Tools.setFetchSize(ctx, this.fetchSize);
        int m = SettingsTools.getMaxRows(this.maxRows, ctx.settings());
        if (m != 0) {
            ctx.statement().setMaxRows(m);
        }
    }

    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int f = SettingsTools.getFetchSize(this.fetchSize, ctx.settings());
        if (REPORT_FETCH_SIZE_WITH_AUTOCOMMIT.contains((Object)ctx.dialect()) && f != 0 && ctx.connection().getAutoCommit()) {
            log.info((Object)"Fetch Size", "A fetch size of " + f + " was set on a auto-commit PostgreSQL connection, which is not recommended. See http://jdbc.postgresql.org/documentation/head/query.html#query-with-cursor");
        }
        SQLException e = Tools.executeStatementAndGetFirstResultSet(ctx, this.rendered.skipUpdateCounts);
        listener.executeEnd(ctx);
        if (!this.many) {
            if (e == null) {
                if (ctx.resultSet() == null) {
                    DSLContext dsl = DSL.using(ctx.configuration());
                    Field<Integer> c = DSL.field(DSL.name("UPDATE_COUNT"), Integer.TYPE);
                    Result<Record1<Integer>> r = dsl.newResult(c);
                    r.add(dsl.newRecord(c).values(ctx.rows()));
                    ctx.resultSet(new MockResultSet(r));
                }
                Field<?>[] fields = this.getFields(ctx.resultSet().getMetaData());
                this.cursor = new CursorImpl<R>(ctx, listener, fields, this.intern.internIndexes(fields), this.keepStatement(), this.keepResultSet(), this.getRecordType(), SettingsTools.getMaxRows(this.maxRows, ctx.settings()), this.autoclosing);
                if (!this.lazy) {
                    this.result = this.cursor.fetch();
                    this.cursor = null;
                }
            }
        } else {
            this.results = new ResultsImpl(ctx.configuration());
            Tools.consumeResultSets(ctx, listener, this.results, this.intern, e);
        }
        return this.result != null ? this.result.size() : 0;
    }

    @Override
    protected final boolean keepResultSet() {
        return this.lazy;
    }

    final Collection<? extends Field<?>> coerce() {
        return this.coerceFields;
    }

    @Override
    public final Result<R> fetch() {
        this.execute();
        return this.result;
    }

    @Override
    public final ResultSet fetchResultSet() {
        return this.fetchLazy().resultSet();
    }

    @Override
    public final Iterator<R> iterator() {
        return this.fetch().iterator();
    }

    public final void subscribe(Subscriber<? super R> subscriber) {
        subscriber.onSubscribe(new R2DBC.BlockingRecordSubscription<R>(this, subscriber));
    }

    @Override
    public final CompletionStage<Result<R>> fetchAsync() {
        return this.fetchAsync(Tools.configuration(this).executorProvider().provide());
    }

    @Override
    public final CompletionStage<Result<R>> fetchAsync(Executor executor) {
        return ExecutorProviderCompletionStage.of(CompletableFuture.supplyAsync(Tools.blocking(this::fetch), executor), () -> executor);
    }

    @Override
    public final Stream<R> fetchStream() {
        AtomicReference r = new AtomicReference();
        return (Stream)StreamSupport.stream(() -> {
            Cursor<R> c = this.fetchLazy();
            r.set(c);
            return c.spliterator();
        }, 1296, false).onClose(() -> JDBCUtils.safeClose((AutoCloseable)r.get()));
    }

    @Override
    public final <E> Stream<E> fetchStreamInto(Class<? extends E> type) {
        return this.fetchStream().map(r -> r.into(type));
    }

    @Override
    public final <Z extends Record> Stream<Z> fetchStreamInto(Table<Z> table) {
        return this.fetchStream().map(r -> r.into(table));
    }

    @Override
    public final Stream<R> stream() {
        return this.fetchStream();
    }

    @Override
    public final <X, A> X collect(Collector<? super R, A, X> collector) {
        try (Cursor<? super R> c = this.fetchLazyNonAutoClosing();){
            X x = c.collect(collector);
            return x;
        }
    }

    @Override
    public final Cursor<R> fetchLazy() {
        return this.fetchLazy(this.fetchSize);
    }

    final Cursor<R> fetchLazyNonAutoClosing() {
        boolean previousAutoClosing = this.autoclosing;
        this.autoclosing = false;
        try {
            Cursor<R> cursor = this.fetchLazy();
            return cursor;
        }
        finally {
            this.autoclosing = previousAutoClosing;
        }
    }

    @Override
    @Deprecated
    public final Cursor<R> fetchLazy(int size) {
        int previousFetchSize = this.fetchSize;
        this.lazy = true;
        this.fetchSize = size;
        try {
            this.execute();
        }
        finally {
            this.lazy = false;
            this.fetchSize = previousFetchSize;
        }
        return this.cursor;
    }

    @Override
    public final Results fetchMany() {
        this.many = true;
        try {
            this.execute();
        }
        finally {
            this.many = false;
        }
        return this.results;
    }

    @Override
    public final <T> List<T> fetch(Field<T> field) {
        return this.fetch().getValues(field);
    }

    @Override
    public final <U> List<U> fetch(Field<?> field, Class<? extends U> type) {
        return this.fetch().getValues(field, type);
    }

    @Override
    public final <T, U> List<U> fetch(Field<T> field, Converter<? super T, ? extends U> converter) {
        return this.fetch().getValues(field, converter);
    }

    @Override
    public final List<?> fetch(int fieldIndex) {
        return this.fetch().getValues(fieldIndex);
    }

    @Override
    public final <U> List<U> fetch(int fieldIndex, Class<? extends U> type) {
        return this.fetch().getValues(fieldIndex, type);
    }

    @Override
    public final <U> List<U> fetch(int fieldIndex, Converter<?, ? extends U> converter) {
        return this.fetch().getValues(fieldIndex, converter);
    }

    @Override
    public final List<?> fetch(String fieldName) {
        return this.fetch().getValues(fieldName);
    }

    @Override
    public final <U> List<U> fetch(String fieldName, Class<? extends U> type) {
        return this.fetch().getValues(fieldName, type);
    }

    @Override
    public final <U> List<U> fetch(String fieldName, Converter<?, ? extends U> converter) {
        return this.fetch().getValues(fieldName, converter);
    }

    @Override
    public final List<?> fetch(Name fieldName) {
        return this.fetch().getValues(fieldName);
    }

    @Override
    public final <U> List<U> fetch(Name fieldName, Class<? extends U> type) {
        return this.fetch().getValues(fieldName, type);
    }

    @Override
    public final <U> List<U> fetch(Name fieldName, Converter<?, ? extends U> converter) {
        return this.fetch().getValues(fieldName, converter);
    }

    @Override
    public final <T> T fetchOne(Field<T> field) {
        R record = this.fetchOne();
        return record == null ? null : (T)record.get(field);
    }

    @Override
    public final <U> U fetchOne(Field<?> field, Class<? extends U> type) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(field, type);
    }

    @Override
    public final <T, U> U fetchOne(Field<T> field, Converter<? super T, ? extends U> converter) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(field, converter);
    }

    @Override
    public final Object fetchOne(int fieldIndex) {
        R record = this.fetchOne();
        return record == null ? null : record.get(fieldIndex);
    }

    @Override
    public final <U> U fetchOne(int fieldIndex, Class<? extends U> type) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(fieldIndex, type);
    }

    @Override
    public final <U> U fetchOne(int fieldIndex, Converter<?, ? extends U> converter) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(fieldIndex, converter);
    }

    @Override
    public final Object fetchOne(String fieldName) {
        R record = this.fetchOne();
        return record == null ? null : record.get(fieldName);
    }

    @Override
    public final <U> U fetchOne(String fieldName, Class<? extends U> type) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(fieldName, type);
    }

    @Override
    public final <U> U fetchOne(String fieldName, Converter<?, ? extends U> converter) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(fieldName, converter);
    }

    @Override
    public final Object fetchOne(Name fieldName) {
        R record = this.fetchOne();
        return record == null ? null : record.get(fieldName);
    }

    @Override
    public final <U> U fetchOne(Name fieldName, Class<? extends U> type) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(fieldName, type);
    }

    @Override
    public final <U> U fetchOne(Name fieldName, Converter<?, ? extends U> converter) {
        R record = this.fetchOne();
        return record == null ? null : (U)record.get(fieldName, converter);
    }

    @Override
    public final R fetchOne() {
        return Tools.fetchOne(this.fetchLazyNonAutoClosing(), this.hasLimit1());
    }

    @Override
    public final <E> E fetchOne(RecordMapper<? super R, E> mapper) {
        R record = this.fetchOne();
        return record == null ? null : (E)mapper.map((R)record);
    }

    @Override
    public final Map<String, Object> fetchOneMap() {
        R record = this.fetchOne();
        return record == null ? null : record.intoMap();
    }

    @Override
    public final Object[] fetchOneArray() {
        R record = this.fetchOne();
        return record == null ? null : record.intoArray();
    }

    @Override
    public final <E> E fetchOneInto(Class<? extends E> type) {
        R record = this.fetchOne();
        return (E)(record == null ? null : record.into(type));
    }

    @Override
    public final <Z extends Record> Z fetchOneInto(Table<Z> table) {
        R record = this.fetchOne();
        return record == null ? null : (Z)record.into(table);
    }

    @Override
    public final <T> T fetchSingle(Field<T> field) {
        return this.fetchSingle().get(field);
    }

    @Override
    public final <U> U fetchSingle(Field<?> field, Class<? extends U> type) {
        return this.fetchSingle().get(field, type);
    }

    @Override
    public final <T, U> U fetchSingle(Field<T> field, Converter<? super T, ? extends U> converter) {
        return this.fetchSingle().get(field, converter);
    }

    @Override
    public final Object fetchSingle(int fieldIndex) {
        return this.fetchSingle().get(fieldIndex);
    }

    @Override
    public final <U> U fetchSingle(int fieldIndex, Class<? extends U> type) {
        return this.fetchSingle().get(fieldIndex, type);
    }

    @Override
    public final <U> U fetchSingle(int fieldIndex, Converter<?, ? extends U> converter) {
        return this.fetchSingle().get(fieldIndex, converter);
    }

    @Override
    public final Object fetchSingle(String fieldName) {
        return this.fetchSingle().get(fieldName);
    }

    @Override
    public final <U> U fetchSingle(String fieldName, Class<? extends U> type) {
        return this.fetchSingle().get(fieldName, type);
    }

    @Override
    public final <U> U fetchSingle(String fieldName, Converter<?, ? extends U> converter) {
        return this.fetchSingle().get(fieldName, converter);
    }

    @Override
    public final Object fetchSingle(Name fieldName) {
        return this.fetchSingle().get(fieldName);
    }

    @Override
    public final <U> U fetchSingle(Name fieldName, Class<? extends U> type) {
        return this.fetchSingle().get(fieldName, type);
    }

    @Override
    public final <U> U fetchSingle(Name fieldName, Converter<?, ? extends U> converter) {
        return this.fetchSingle().get(fieldName, converter);
    }

    @Override
    public final R fetchSingle() {
        return Tools.fetchSingle(this.fetchLazyNonAutoClosing(), this.hasLimit1());
    }

    @Override
    public final <E> E fetchSingle(RecordMapper<? super R, E> mapper) {
        return mapper.map(this.fetchSingle());
    }

    @Override
    public final Map<String, Object> fetchSingleMap() {
        return this.fetchSingle().intoMap();
    }

    @Override
    public final Object[] fetchSingleArray() {
        return this.fetchSingle().intoArray();
    }

    @Override
    public final <E> E fetchSingleInto(Class<? extends E> type) {
        return (E)this.fetchSingle().into(type);
    }

    @Override
    public final <Z extends Record> Z fetchSingleInto(Table<Z> table) {
        return this.fetchSingle().into(table);
    }

    @Override
    public final <T> Optional<T> fetchOptional(Field<T> field) {
        return Optional.ofNullable(this.fetchOne(field));
    }

    @Override
    public final <U> Optional<U> fetchOptional(Field<?> field, Class<? extends U> type) {
        return Optional.ofNullable(this.fetchOne(field, type));
    }

    @Override
    public final <T, U> Optional<U> fetchOptional(Field<T> field, Converter<? super T, ? extends U> converter) {
        return Optional.ofNullable(this.fetchOne(field, converter));
    }

    @Override
    public final Optional<?> fetchOptional(int fieldIndex) {
        return Optional.ofNullable(this.fetchOne(fieldIndex));
    }

    @Override
    public final <U> Optional<U> fetchOptional(int fieldIndex, Class<? extends U> type) {
        return Optional.ofNullable(this.fetchOne(fieldIndex, type));
    }

    @Override
    public final <U> Optional<U> fetchOptional(int fieldIndex, Converter<?, ? extends U> converter) {
        return Optional.ofNullable(this.fetchOne(fieldIndex, converter));
    }

    @Override
    public final Optional<?> fetchOptional(String fieldName) {
        return Optional.ofNullable(this.fetchOne(fieldName));
    }

    @Override
    public final <U> Optional<U> fetchOptional(String fieldName, Class<? extends U> type) {
        return Optional.ofNullable(this.fetchOne(fieldName, type));
    }

    @Override
    public final <U> Optional<U> fetchOptional(String fieldName, Converter<?, ? extends U> converter) {
        return Optional.ofNullable(this.fetchOne(fieldName, converter));
    }

    @Override
    public final Optional<?> fetchOptional(Name fieldName) {
        return Optional.ofNullable(this.fetchOne(fieldName));
    }

    @Override
    public final <U> Optional<U> fetchOptional(Name fieldName, Class<? extends U> type) {
        return Optional.ofNullable(this.fetchOne(fieldName, type));
    }

    @Override
    public final <U> Optional<U> fetchOptional(Name fieldName, Converter<?, ? extends U> converter) {
        return Optional.ofNullable(this.fetchOne(fieldName, converter));
    }

    @Override
    public final Optional<R> fetchOptional() {
        return Optional.ofNullable(this.fetchOne());
    }

    @Override
    public final <E> Optional<E> fetchOptional(RecordMapper<? super R, E> mapper) {
        return Optional.ofNullable(this.fetchOne(mapper));
    }

    @Override
    public final Optional<Map<String, Object>> fetchOptionalMap() {
        return Optional.ofNullable(this.fetchOneMap());
    }

    @Override
    public final Optional<Object[]> fetchOptionalArray() {
        return Optional.ofNullable(this.fetchOneArray());
    }

    @Override
    public final <E> Optional<E> fetchOptionalInto(Class<? extends E> type) {
        return Optional.ofNullable(this.fetchOneInto(type));
    }

    @Override
    public final <Z extends Record> Optional<Z> fetchOptionalInto(Table<Z> table) {
        return Optional.ofNullable(this.fetchOneInto(table));
    }

    @Override
    public final <T> T fetchAny(Field<T> field) {
        R record = this.fetchAny();
        return record == null ? null : (T)record.get(field);
    }

    @Override
    public final <U> U fetchAny(Field<?> field, Class<? extends U> type) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(field, type);
    }

    @Override
    public final <T, U> U fetchAny(Field<T> field, Converter<? super T, ? extends U> converter) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(field, converter);
    }

    @Override
    public final Object fetchAny(int fieldIndex) {
        R record = this.fetchAny();
        return record == null ? null : record.get(fieldIndex);
    }

    @Override
    public final <U> U fetchAny(int fieldIndex, Class<? extends U> type) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(fieldIndex, type);
    }

    @Override
    public final <U> U fetchAny(int fieldIndex, Converter<?, ? extends U> converter) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(fieldIndex, converter);
    }

    @Override
    public final Object fetchAny(String fieldName) {
        R record = this.fetchAny();
        return record == null ? null : record.get(fieldName);
    }

    @Override
    public final <U> U fetchAny(String fieldName, Class<? extends U> type) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(fieldName, type);
    }

    @Override
    public final <U> U fetchAny(String fieldName, Converter<?, ? extends U> converter) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(fieldName, converter);
    }

    @Override
    public final Object fetchAny(Name fieldName) {
        R record = this.fetchAny();
        return record == null ? null : record.get(fieldName);
    }

    @Override
    public final <U> U fetchAny(Name fieldName, Class<? extends U> type) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(fieldName, type);
    }

    @Override
    public final <U> U fetchAny(Name fieldName, Converter<?, ? extends U> converter) {
        R record = this.fetchAny();
        return record == null ? null : (U)record.get(fieldName, converter);
    }

    @Override
    public final R fetchAny() {
        try (Cursor<R> c = this.fetchLazyNonAutoClosing();){
            R r = c.fetchNext();
            return r;
        }
    }

    @Override
    public final <E> E fetchAny(RecordMapper<? super R, E> mapper) {
        R record = this.fetchAny();
        return record == null ? null : (E)mapper.map((R)record);
    }

    @Override
    public final Map<String, Object> fetchAnyMap() {
        R record = this.fetchAny();
        return record == null ? null : record.intoMap();
    }

    @Override
    public final Object[] fetchAnyArray() {
        R record = this.fetchAny();
        return record == null ? null : record.intoArray();
    }

    @Override
    public final <E> E fetchAnyInto(Class<? extends E> type) {
        R record = this.fetchAny();
        return (E)(record == null ? null : record.into(type));
    }

    @Override
    public final <Z extends Record> Z fetchAnyInto(Table<Z> table) {
        R record = this.fetchAny();
        return record == null ? null : (Z)record.into(table);
    }

    @Override
    public final <K> Map<K, R> fetchMap(Field<K> key) {
        return this.fetch().intoMap(key);
    }

    @Override
    public final Map<?, R> fetchMap(int keyFieldIndex) {
        return this.fetch().intoMap(keyFieldIndex);
    }

    @Override
    public final Map<?, R> fetchMap(String keyFieldName) {
        return this.fetch().intoMap(keyFieldName);
    }

    @Override
    public final Map<?, R> fetchMap(Name keyFieldName) {
        return this.fetch().intoMap(keyFieldName);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Field<K> key, Field<V> value) {
        return this.fetch().intoMap(key, value);
    }

    @Override
    public final Map<?, ?> fetchMap(int keyFieldIndex, int valueFieldIndex) {
        return this.fetch().intoMap(keyFieldIndex, valueFieldIndex);
    }

    @Override
    public final Map<?, ?> fetchMap(String keyFieldName, String valueFieldName) {
        return this.fetch().intoMap(keyFieldName, valueFieldName);
    }

    @Override
    public final Map<?, ?> fetchMap(Name keyFieldName, Name valueFieldName) {
        return this.fetch().intoMap(keyFieldName, valueFieldName);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, Class<? extends E> type) {
        return this.fetch().intoMap(key, type);
    }

    @Override
    public final <E> Map<?, E> fetchMap(int keyFieldIndex, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldIndex, type);
    }

    @Override
    public final <E> Map<?, E> fetchMap(String keyFieldName, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldName, type);
    }

    @Override
    public final <E> Map<?, E> fetchMap(Name keyFieldName, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldName, type);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(key, mapper);
    }

    @Override
    public final <E> Map<?, E> fetchMap(int keyFieldIndex, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldIndex, mapper);
    }

    @Override
    public final <E> Map<?, E> fetchMap(String keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldName, mapper);
    }

    @Override
    public final <E> Map<?, E> fetchMap(Name keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldName, mapper);
    }

    @Override
    public final Map<Record, R> fetchMap(Field<?>[] keys) {
        return this.fetch().intoMap(keys);
    }

    @Override
    public final Map<Record, R> fetchMap(int[] keyFieldIndexes) {
        return this.fetch().intoMap(keyFieldIndexes);
    }

    @Override
    public final Map<Record, R> fetchMap(String[] keyFieldNames) {
        return this.fetch().intoMap(keyFieldNames);
    }

    @Override
    public final Map<Record, R> fetchMap(Name[] keyFieldNames) {
        return this.fetch().intoMap(keyFieldNames);
    }

    @Override
    public final Map<Record, Record> fetchMap(Field<?>[] keys, Field<?>[] values) {
        return this.fetch().intoMap(keys, values);
    }

    @Override
    public final Map<Record, Record> fetchMap(int[] keyFieldIndexes, int[] valueFieldIndexes) {
        return this.fetch().intoMap(keyFieldIndexes, valueFieldIndexes);
    }

    @Override
    public final Map<Record, Record> fetchMap(String[] keyFieldNames, String[] valueFieldNames) {
        return this.fetch().intoMap(keyFieldNames, valueFieldNames);
    }

    @Override
    public final Map<Record, Record> fetchMap(Name[] keyFieldNames, Name[] valueFieldNames) {
        return this.fetch().intoMap(keyFieldNames, valueFieldNames);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, Class<? extends E> type) {
        return this.fetch().intoMap(keys, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(int[] keyFieldIndexes, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldIndexes, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(String[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldNames, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Name[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoMap(keyFieldNames, type);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keys, mapper);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(int[] keyFieldIndexes, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldIndexes, mapper);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(String[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldNames, mapper);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Name[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(keyFieldNames, mapper);
    }

    @Override
    public final <K> Map<K, R> fetchMap(Class<? extends K> keyType) {
        return this.fetch().intoMap(keyType);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Class<? extends K> keyType, Class<? extends V> valueType) {
        return this.fetch().intoMap(keyType, valueType);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Class<? extends K> keyType, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoMap(keyType, valueMapper);
    }

    @Override
    public final <K> Map<K, R> fetchMap(RecordMapper<? super R, K> keyMapper) {
        return this.fetch().intoMap(keyMapper);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(RecordMapper<? super R, K> keyMapper, Class<V> valueType) {
        return this.fetch().intoMap(keyMapper, valueType);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(RecordMapper<? super R, K> keyMapper, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoMap(keyMapper, valueMapper);
    }

    @Override
    public final <S extends Record> Map<S, R> fetchMap(Table<S> table) {
        return this.fetch().intoMap(table);
    }

    @Override
    public final <S extends Record, T extends Record> Map<S, T> fetchMap(Table<S> keyTable, Table<T> valueTable) {
        return this.fetch().intoMap(keyTable, valueTable);
    }

    @Override
    public final <E, S extends Record> Map<S, E> fetchMap(Table<S> table, Class<? extends E> type) {
        return this.fetch().intoMap(table, type);
    }

    @Override
    public final <E, S extends Record> Map<S, E> fetchMap(Table<S> table, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoMap(table, mapper);
    }

    @Override
    public final List<Map<String, Object>> fetchMaps() {
        return this.fetch().intoMaps();
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(Field<K> key) {
        return this.fetch().intoGroups(key);
    }

    @Override
    public final Map<?, Result<R>> fetchGroups(int keyFieldIndex) {
        return this.fetch().intoGroups(keyFieldIndex);
    }

    @Override
    public final Map<?, Result<R>> fetchGroups(String keyFieldName) {
        return this.fetch().intoGroups(keyFieldName);
    }

    @Override
    public final Map<?, Result<R>> fetchGroups(Name keyFieldName) {
        return this.fetch().intoGroups(keyFieldName);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Field<K> key, Field<V> value) {
        return this.fetch().intoGroups(key, value);
    }

    @Override
    public final Map<?, List<?>> fetchGroups(int keyFieldIndex, int valueFieldIndex) {
        return this.fetch().intoGroups(keyFieldIndex, valueFieldIndex);
    }

    @Override
    public final Map<?, List<?>> fetchGroups(String keyFieldName, String valueFieldName) {
        return this.fetch().intoGroups(keyFieldName, valueFieldName);
    }

    @Override
    public final Map<?, List<?>> fetchGroups(Name keyFieldName, Name valueFieldName) {
        return this.fetch().intoGroups(keyFieldName, valueFieldName);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, Class<? extends E> type) {
        return this.fetch().intoGroups(key, type);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(int keyFieldIndex, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldIndex, type);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(String keyFieldName, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldName, type);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(Name keyFieldName, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldName, type);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(key, mapper);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(int keyFieldIndex, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldIndex, mapper);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(String keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldName, mapper);
    }

    @Override
    public final <E> Map<?, List<E>> fetchGroups(Name keyFieldName, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldName, mapper);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(Field<?>[] keys) {
        return this.fetch().intoGroups(keys);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(int[] keyFieldIndexes) {
        return this.fetch().intoGroups(keyFieldIndexes);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(String[] keyFieldNames) {
        return this.fetch().intoGroups(keyFieldNames);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(Name[] keyFieldNames) {
        return this.fetch().intoGroups(keyFieldNames);
    }

    @Override
    public final Map<Record, Result<Record>> fetchGroups(Field<?>[] keys, Field<?>[] values) {
        return this.fetch().intoGroups(keys, values);
    }

    @Override
    public final Map<Record, Result<Record>> fetchGroups(int[] keyFieldIndexes, int[] valueFieldIndexes) {
        return this.fetch().intoGroups(keyFieldIndexes, valueFieldIndexes);
    }

    @Override
    public final Map<Record, Result<Record>> fetchGroups(String[] keyFieldNames, String[] valueFieldNames) {
        return this.fetch().intoGroups(keyFieldNames, valueFieldNames);
    }

    @Override
    public final Map<Record, Result<Record>> fetchGroups(Name[] keyFieldNames, Name[] valueFieldNames) {
        return this.fetch().intoGroups(keyFieldNames, valueFieldNames);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, Class<? extends E> type) {
        return this.fetch().intoGroups(keys, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(int[] keyFieldIndexes, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldIndexes, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(String[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldNames, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Name[] keyFieldNames, Class<? extends E> type) {
        return this.fetch().intoGroups(keyFieldNames, type);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(int[] keyFieldIndexes, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldIndexes, mapper);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(String[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldNames, mapper);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Name[] keyFieldNames, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keyFieldNames, mapper);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(keys, mapper);
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(Class<? extends K> keyType) {
        return this.fetch().intoGroups(keyType);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Class<? extends K> keyType, Class<? extends V> valueType) {
        return this.fetch().intoGroups(keyType, valueType);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Class<? extends K> keyType, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoGroups(keyType, valueMapper);
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(RecordMapper<? super R, K> keyMapper) {
        return this.fetch().intoGroups(keyMapper);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(RecordMapper<? super R, K> keyMapper, Class<V> valueType) {
        return this.fetch().intoGroups(keyMapper, valueType);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(RecordMapper<? super R, K> keyMapper, RecordMapper<? super R, V> valueMapper) {
        return this.fetch().intoGroups(keyMapper, valueMapper);
    }

    @Override
    public final <S extends Record> Map<S, Result<R>> fetchGroups(Table<S> table) {
        return this.fetch().intoGroups(table);
    }

    @Override
    public final <S extends Record, T extends Record> Map<S, Result<T>> fetchGroups(Table<S> keyTable, Table<T> valueTable) {
        return this.fetch().intoGroups(keyTable, valueTable);
    }

    @Override
    public final <E, S extends Record> Map<S, List<E>> fetchGroups(Table<S> table, Class<? extends E> type) {
        return this.fetch().intoGroups(table, type);
    }

    @Override
    public final <E, S extends Record> Map<S, List<E>> fetchGroups(Table<S> table, RecordMapper<? super R, E> mapper) {
        return this.fetch().intoGroups(table, mapper);
    }

    @Override
    public final Object[][] fetchArrays() {
        return this.fetch().intoArrays();
    }

    @Override
    public final R[] fetchArray() {
        Result<R> r = this.fetch();
        if (r.isNotEmpty()) {
            return r.toArray((Record[])Array.newInstance(((Record)r.get(0)).getClass(), r.size()));
        }
        return r.toArray((Record[])Array.newInstance(this.getRecordType(), r.size()));
    }

    @Override
    public final Object[] fetchArray(int fieldIndex) {
        return this.fetch().intoArray(fieldIndex);
    }

    @Override
    public final <U> U[] fetchArray(int fieldIndex, Class<? extends U> type) {
        return this.fetch().intoArray(fieldIndex, type);
    }

    @Override
    public final <U> U[] fetchArray(int fieldIndex, Converter<?, ? extends U> converter) {
        return this.fetch().intoArray(fieldIndex, converter);
    }

    @Override
    public final Object[] fetchArray(String fieldName) {
        return this.fetch().intoArray(fieldName);
    }

    @Override
    public final <U> U[] fetchArray(String fieldName, Class<? extends U> type) {
        return this.fetch().intoArray(fieldName, type);
    }

    @Override
    public final <U> U[] fetchArray(String fieldName, Converter<?, ? extends U> converter) {
        return this.fetch().intoArray(fieldName, converter);
    }

    @Override
    public final Object[] fetchArray(Name fieldName) {
        return this.fetch().intoArray(fieldName);
    }

    @Override
    public final <U> U[] fetchArray(Name fieldName, Class<? extends U> type) {
        return this.fetch().intoArray(fieldName, type);
    }

    @Override
    public final <U> U[] fetchArray(Name fieldName, Converter<?, ? extends U> converter) {
        return this.fetch().intoArray(fieldName, converter);
    }

    @Override
    public final <T> T[] fetchArray(Field<T> field) {
        return this.fetch().intoArray(field);
    }

    @Override
    public final <U> U[] fetchArray(Field<?> field, Class<? extends U> type) {
        return this.fetch().intoArray(field, type);
    }

    @Override
    public final <T, U> U[] fetchArray(Field<T> field, Converter<? super T, ? extends U> converter) {
        return this.fetch().intoArray(field, converter);
    }

    @Override
    public final <E> Set<E> fetchSet(RecordMapper<? super R, E> mapper) {
        return this.fetch().intoSet(mapper);
    }

    @Override
    public final Set<?> fetchSet(int fieldIndex) {
        return this.fetch().intoSet(fieldIndex);
    }

    @Override
    public final <U> Set<U> fetchSet(int fieldIndex, Class<? extends U> type) {
        return this.fetch().intoSet(fieldIndex, type);
    }

    @Override
    public final <U> Set<U> fetchSet(int fieldIndex, Converter<?, ? extends U> converter) {
        return this.fetch().intoSet(fieldIndex, converter);
    }

    @Override
    public final Set<?> fetchSet(String fieldName) {
        return this.fetch().intoSet(fieldName);
    }

    @Override
    public final <U> Set<U> fetchSet(String fieldName, Class<? extends U> type) {
        return this.fetch().intoSet(fieldName, type);
    }

    @Override
    public final <U> Set<U> fetchSet(String fieldName, Converter<?, ? extends U> converter) {
        return this.fetch().intoSet(fieldName, converter);
    }

    @Override
    public final Set<?> fetchSet(Name fieldName) {
        return this.fetch().intoSet(fieldName);
    }

    @Override
    public final <U> Set<U> fetchSet(Name fieldName, Class<? extends U> type) {
        return this.fetch().intoSet(fieldName, type);
    }

    @Override
    public final <U> Set<U> fetchSet(Name fieldName, Converter<?, ? extends U> converter) {
        return this.fetch().intoSet(fieldName, converter);
    }

    @Override
    public final <T> Set<T> fetchSet(Field<T> field) {
        return this.fetch().intoSet(field);
    }

    @Override
    public final <U> Set<U> fetchSet(Field<?> field, Class<? extends U> type) {
        return this.fetch().intoSet(field, type);
    }

    @Override
    public final <T, U> Set<U> fetchSet(Field<T> field, Converter<? super T, ? extends U> converter) {
        return this.fetch().intoSet(field, converter);
    }

    @Override
    public final Class<? extends R> getRecordType() {
        if (this.coerceTable != null) {
            return this.coerceTable.getRecordType();
        }
        return this.getRecordType0();
    }

    abstract Class<? extends R> getRecordType0();

    @Override
    public final <U> List<U> fetchInto(Class<? extends U> type) {
        return this.fetch().into(type);
    }

    @Override
    public final <Z extends Record> Result<Z> fetchInto(Table<Z> table) {
        return this.fetch().into(table);
    }

    @Override
    public final <H extends RecordHandler<? super R>> H fetchInto(H handler) {
        return this.fetch().into(handler);
    }

    @Override
    public final <E> List<E> fetch(RecordMapper<? super R, E> mapper) {
        return this.fetch().map(mapper);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(new ResultQueryCallable());
        return new FutureResultImpl(future, executor);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater(ExecutorService executor) {
        Future future = executor.submit(new ResultQueryCallable());
        return new FutureResultImpl(future);
    }

    @Override
    public final Result<R> getResult() {
        return this.result;
    }

    private final boolean hasLimit1() {
        if (this instanceof SelectQueryImpl) {
            Limit l = ((SelectQueryImpl)this).getLimit();
            return !l.withTies() && !l.percent() && l.limitOne();
        }
        return false;
    }

    @Override
    public final <X extends Record> ResultQuery<X> coerce(Table<X> table) {
        this.coerceTable = table;
        return this.coerce(Arrays.asList(table.fields()));
    }

    @Override
    public final ResultQuery<Record> coerce(Field<?> ... fields) {
        return this.coerce(Arrays.asList(fields));
    }

    @Override
    public final ResultQuery<Record> coerce(Collection<? extends Field<?>> fields) {
        this.coerceFields = fields;
        return this;
    }

    @Override
    public final <T1> ResultQuery<Record1<T1>> coerce(Field<T1> field1) {
        return this.coerce(new Field[]{field1});
    }

    @Override
    public final <T1, T2> ResultQuery<Record2<T1, T2>> coerce(Field<T1> field1, Field<T2> field2) {
        return this.coerce(new Field[]{field1, field2});
    }

    @Override
    public final <T1, T2, T3> ResultQuery<Record3<T1, T2, T3>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3) {
        return this.coerce(new Field[]{field1, field2, field3});
    }

    @Override
    public final <T1, T2, T3, T4> ResultQuery<Record4<T1, T2, T3, T4>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4) {
        return this.coerce(new Field[]{field1, field2, field3, field4});
    }

    @Override
    public final <T1, T2, T3, T4, T5> ResultQuery<Record5<T1, T2, T3, T4, T5>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6> ResultQuery<Record6<T1, T2, T3, T4, T5, T6>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7> ResultQuery<Record7<T1, T2, T3, T4, T5, T6, T7>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8> ResultQuery<Record8<T1, T2, T3, T4, T5, T6, T7, T8>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9> ResultQuery<Record9<T1, T2, T3, T4, T5, T6, T7, T8, T9>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ResultQuery<Record10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ResultQuery<Record11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ResultQuery<Record12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ResultQuery<Record13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ResultQuery<Record14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ResultQuery<Record15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ResultQuery<Record16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ResultQuery<Record17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16, Field<T17> field17) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ResultQuery<Record18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16, Field<T17> field17, Field<T18> field18) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ResultQuery<Record19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16, Field<T17> field17, Field<T18> field18, Field<T19> field19) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ResultQuery<Record20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16, Field<T17> field17, Field<T18> field18, Field<T19> field19, Field<T20> field20) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19, field20});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ResultQuery<Record21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16, Field<T17> field17, Field<T18> field18, Field<T19> field19, Field<T20> field20, Field<T21> field21) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19, field20, field21});
    }

    @Override
    public final <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ResultQuery<Record22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> coerce(Field<T1> field1, Field<T2> field2, Field<T3> field3, Field<T4> field4, Field<T5> field5, Field<T6> field6, Field<T7> field7, Field<T8> field8, Field<T9> field9, Field<T10> field10, Field<T11> field11, Field<T12> field12, Field<T13> field13, Field<T14> field14, Field<T15> field15, Field<T16> field16, Field<T17> field17, Field<T18> field18, Field<T19> field19, Field<T20> field20, Field<T21> field21, Field<T22> field22) {
        return this.coerce(new Field[]{field1, field2, field3, field4, field5, field6, field7, field8, field9, field10, field11, field12, field13, field14, field15, field16, field17, field18, field19, field20, field21, field22});
    }

    private final class ResultQueryCallable
    implements Callable<Result<R>> {
        private ResultQueryCallable() {
        }

        @Override
        public final Result<R> call() throws Exception {
            return AbstractResultQuery.this.fetch();
        }
    }
}

