/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.AlterDomainDropConstraintCascadeStep;
import org.jooq.AlterDomainFinalStep;
import org.jooq.AlterDomainRenameConstraintStep;
import org.jooq.AlterDomainStep;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.Domain;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.ConstraintImpl;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterDomainImpl<T>
extends AbstractRowCountQuery
implements AlterDomainStep<T>,
AlterDomainDropConstraintCascadeStep,
AlterDomainRenameConstraintStep,
AlterDomainFinalStep {
    private static final long serialVersionUID = 1L;
    private final Domain<T> domain;
    private final boolean alterDomainIfExists;
    private Constraint addConstraint;
    private Constraint dropConstraint;
    private boolean dropConstraintIfExists;
    private Domain<?> renameTo;
    private Constraint renameConstraint;
    private boolean renameConstraintIfExists;
    private Field<T> setDefault;
    private boolean dropDefault;
    private boolean setNotNull;
    private boolean dropNotNull;
    private Boolean cascade;
    private Constraint renameConstraintTo;
    private static final Set<SQLDialect> NO_SUPPORT_RENAME_CONSTRAINT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NO_SUPPORT_DROP_CONSTRAINT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.FIREBIRD);

    AlterDomainImpl(Configuration configuration, Domain domain, boolean alterDomainIfExists) {
        this(configuration, domain, alterDomainIfExists, null, null, false, null, null, false, null, false, false, false, null, null);
    }

    AlterDomainImpl(Configuration configuration, Domain domain, boolean alterDomainIfExists, Constraint addConstraint, Constraint dropConstraint, boolean dropConstraintIfExists, Domain renameTo, Constraint renameConstraint, boolean renameConstraintIfExists, Field setDefault, boolean dropDefault, boolean setNotNull, boolean dropNotNull, Boolean cascade, Constraint renameConstraintTo) {
        super(configuration);
        this.domain = domain;
        this.alterDomainIfExists = alterDomainIfExists;
        this.addConstraint = addConstraint;
        this.dropConstraint = dropConstraint;
        this.dropConstraintIfExists = dropConstraintIfExists;
        this.renameTo = renameTo;
        this.renameConstraint = renameConstraint;
        this.renameConstraintIfExists = renameConstraintIfExists;
        this.setDefault = setDefault;
        this.dropDefault = dropDefault;
        this.setNotNull = setNotNull;
        this.dropNotNull = dropNotNull;
        this.cascade = cascade;
        this.renameConstraintTo = renameConstraintTo;
    }

    final Domain<T> $domain() {
        return this.domain;
    }

    final boolean $alterDomainIfExists() {
        return this.alterDomainIfExists;
    }

    final Constraint $addConstraint() {
        return this.addConstraint;
    }

    final Constraint $dropConstraint() {
        return this.dropConstraint;
    }

    final boolean $dropConstraintIfExists() {
        return this.dropConstraintIfExists;
    }

    final Domain<?> $renameTo() {
        return this.renameTo;
    }

    final Constraint $renameConstraint() {
        return this.renameConstraint;
    }

    final boolean $renameConstraintIfExists() {
        return this.renameConstraintIfExists;
    }

    final Field<T> $setDefault() {
        return this.setDefault;
    }

    final boolean $dropDefault() {
        return this.dropDefault;
    }

    final boolean $setNotNull() {
        return this.setNotNull;
    }

    final boolean $dropNotNull() {
        return this.dropNotNull;
    }

    final Boolean $cascade() {
        return this.cascade;
    }

    final Constraint $renameConstraintTo() {
        return this.renameConstraintTo;
    }

    @Override
    public final AlterDomainImpl<T> add(Constraint addConstraint) {
        this.addConstraint = addConstraint;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> dropConstraint(String dropConstraint) {
        return this.dropConstraint(DSL.constraint(DSL.name(dropConstraint)));
    }

    @Override
    public final AlterDomainImpl<T> dropConstraint(Name dropConstraint) {
        return this.dropConstraint(DSL.constraint(dropConstraint));
    }

    @Override
    public final AlterDomainImpl<T> dropConstraint(Constraint dropConstraint) {
        this.dropConstraint = dropConstraint;
        this.dropConstraintIfExists = false;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> dropConstraintIfExists(String dropConstraint) {
        return this.dropConstraintIfExists(DSL.constraint(DSL.name(dropConstraint)));
    }

    @Override
    public final AlterDomainImpl<T> dropConstraintIfExists(Name dropConstraint) {
        return this.dropConstraintIfExists(DSL.constraint(dropConstraint));
    }

    @Override
    public final AlterDomainImpl<T> dropConstraintIfExists(Constraint dropConstraint) {
        this.dropConstraint = dropConstraint;
        this.dropConstraintIfExists = true;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> renameTo(String renameTo) {
        return this.renameTo((Domain)DSL.domain(DSL.name(renameTo)));
    }

    @Override
    public final AlterDomainImpl<T> renameTo(Name renameTo) {
        return this.renameTo((Domain)DSL.domain(renameTo));
    }

    @Override
    public final AlterDomainImpl<T> renameTo(Domain<?> renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> renameConstraint(String renameConstraint) {
        return this.renameConstraint(DSL.constraint(DSL.name(renameConstraint)));
    }

    @Override
    public final AlterDomainImpl<T> renameConstraint(Name renameConstraint) {
        return this.renameConstraint(DSL.constraint(renameConstraint));
    }

    @Override
    public final AlterDomainImpl<T> renameConstraint(Constraint renameConstraint) {
        this.renameConstraint = renameConstraint;
        this.renameConstraintIfExists = false;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> renameConstraintIfExists(String renameConstraint) {
        return this.renameConstraintIfExists(DSL.constraint(DSL.name(renameConstraint)));
    }

    @Override
    public final AlterDomainImpl<T> renameConstraintIfExists(Name renameConstraint) {
        return this.renameConstraintIfExists(DSL.constraint(renameConstraint));
    }

    @Override
    public final AlterDomainImpl<T> renameConstraintIfExists(Constraint renameConstraint) {
        this.renameConstraint = renameConstraint;
        this.renameConstraintIfExists = true;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> setDefault(T setDefault) {
        return this.setDefault((Field)Tools.field(setDefault));
    }

    @Override
    public final AlterDomainImpl<T> setDefault(Field<T> setDefault) {
        this.setDefault = setDefault;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> dropDefault() {
        this.dropDefault = true;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> setNotNull() {
        this.setNotNull = true;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> dropNotNull() {
        this.dropNotNull = true;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> restrict() {
        this.cascade = false;
        return this;
    }

    @Override
    public final AlterDomainImpl<T> to(String renameConstraintTo) {
        return this.to(DSL.constraint(DSL.name(renameConstraintTo)));
    }

    @Override
    public final AlterDomainImpl<T> to(Name renameConstraintTo) {
        return this.to(DSL.constraint(renameConstraintTo));
    }

    @Override
    public final AlterDomainImpl<T> to(Constraint renameConstraintTo) {
        this.renameConstraintTo = renameConstraintTo;
        return this;
    }

    private final boolean supportsRenameConstraintIfExists(Context<?> ctx) {
        return !NO_SUPPORT_RENAME_CONSTRAINT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    private final boolean supportsDropConstraintIfExists(Context<?> ctx) {
        return !NO_SUPPORT_DROP_CONSTRAINT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.renameConstraintIfExists && !this.supportsRenameConstraintIfExists(ctx) || this.dropConstraintIfExists && !this.supportsDropConstraintIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.ALTER_DOMAIN);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.ALTER_DOMAIN);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        Object previous = ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE);
        ctx.visit(Keywords.K_ALTER).sql(' ').visit(Keywords.K_DOMAIN).sql(' ');
        if (this.alterDomainIfExists) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.domain).sql(' ');
        if (this.addConstraint != null) {
            if (ctx.family() == SQLDialect.FIREBIRD) {
                ctx.visit(Keywords.K_ADD).sql(' ').visit(DSL.check(((ConstraintImpl)this.addConstraint).$check()));
            } else {
                ctx.visit(Keywords.K_ADD).sql(' ').visit(this.addConstraint);
            }
        } else if (this.dropConstraint != null) {
            ctx.visit(Keywords.K_DROP_CONSTRAINT);
            if (this.dropConstraintIfExists && this.supportsDropConstraintIfExists(ctx)) {
                ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
            }
            if (ctx.family() != SQLDialect.FIREBIRD) {
                ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
                ctx.sql(' ').visit(this.dropConstraint);
                ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, previous);
                if (this.cascade != null) {
                    if (this.cascade.booleanValue()) {
                        ctx.sql(' ').visit(Keywords.K_CASCADE);
                    } else {
                        ctx.sql(' ').visit(Keywords.K_RESTRICT);
                    }
                }
            }
        } else if (this.renameTo != null) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
            ctx.visit(ctx.family() == SQLDialect.FIREBIRD ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo);
            ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, previous);
        } else if (this.renameConstraint != null) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
            ctx.visit(Keywords.K_RENAME_CONSTRAINT).sql(' ');
            if (this.renameConstraintIfExists && this.supportsRenameConstraintIfExists(ctx)) {
                ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
            }
            ctx.visit(this.renameConstraint).sql(' ').visit(Keywords.K_TO).sql(' ').visit(this.renameConstraintTo);
            ctx.data((Object)Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, previous);
        } else if (this.setDefault != null) {
            ctx.visit(Keywords.K_SET_DEFAULT).sql(' ').visit(this.setDefault);
        } else if (this.dropDefault) {
            ctx.visit(Keywords.K_DROP_DEFAULT);
        } else if (this.setNotNull) {
            ctx.visit(Keywords.K_SET_NOT_NULL);
        } else if (this.dropNotNull) {
            ctx.visit(Keywords.K_DROP_NOT_NULL);
        }
    }
}

