/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.StringUtils;

final class ArrayGet<T>
extends AbstractField<T> {
    private static final long serialVersionUID = 1852008882778358276L;
    private final Field<T[]> field;
    private final Field<Integer> index;

    ArrayGet(Field<T[]> field, Field<Integer> index) {
        super(Names.N_ARRAY_GET, StringUtils.defaultIfNull(field.getDataType().getArrayComponentDataType(), SQLDataType.OTHER));
        this.field = field;
        this.index = index;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                ctx.visit(Names.N_ARRAY_GET).sql('(').visit(this.field).sql(", ").visit(this.index).sql(')');
                break;
            }
            case HSQLDB: {
                ctx.visit(DSL.when(DSL.cardinality(this.field).ge(this.index), new Standard()));
                break;
            }
            default: {
                ctx.visit(new Standard());
            }
        }
    }

    private class Standard
    extends AbstractField<T> {
        private static final long serialVersionUID = 7727869539823288556L;

        Standard() {
            super(ArrayGet.this.getQualifiedName(), ArrayGet.this.getDataType());
        }

        @Override
        public void accept(Context<?> ctx) {
            ctx.visit(ArrayGet.this.field).sql('[').visit(ArrayGet.this.index).sql(']');
        }
    }
}

