/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropIndexOnStep;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropIndexImpl
extends AbstractRowCountQuery
implements DropIndexOnStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> REQUIRES_ON = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Index index;
    private final boolean ifExists;
    private Table<?> on;
    private Boolean cascade;

    DropIndexImpl(Configuration configuration, Index index) {
        this(configuration, index, false);
    }

    DropIndexImpl(Configuration configuration, Index index, boolean ifExists) {
        super(configuration);
        this.index = index;
        this.ifExists = ifExists;
        this.on = index.getTable();
    }

    final Index $index() {
        return this.index;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    final Table<?> $on() {
        return this.on;
    }

    @Override
    public final DropIndexImpl on(Table<?> table) {
        this.on = table;
        return this;
    }

    @Override
    public final DropIndexImpl on(String tableName) {
        return this.on(DSL.name(tableName));
    }

    @Override
    public final DropIndexImpl on(Name tableName) {
        return this.on((Table)DSL.table(tableName));
    }

    @Override
    public final DropIndexImpl cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final DropIndexImpl restrict() {
        this.cascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_INDEX);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_INDEX);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP_INDEX).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.index);
        if (this.on != null && REQUIRES_ON.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.on);
        }
        if (this.cascade != null) {
            ctx.sql(' ').visit(this.cascade != false ? Keywords.K_CASCADE : Keywords.K_RESTRICT);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

