/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config;

import com.giffing.bucket4j.spring.boot.starter.context.Condition;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.KeyFilter;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricBucketListener;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricTagResult;
import com.giffing.bucket4j.spring.boot.starter.context.properties.BandWidth;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.exception.FilterKeyTypeDeprectatedException;
import com.giffing.bucket4j.spring.boot.starter.exception.FilterURLInvalidException;
import com.giffing.bucket4j.spring.boot.starter.exception.MissingKeyFilterExpressionException;
import com.giffing.bucket4j.spring.boot.starter.exception.MissingMetricTagExpressionException;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.Refill;
import io.github.bucket4j.grid.ProxyManager;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public abstract class Bucket4JBaseConfiguration<R> {
    public abstract List<MetricHandler> getMetricHandlers();

    public FilterConfiguration<R> buildFilterConfig(Bucket4JConfiguration config, ProxyManager<String> buckets, ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory) {
        config.getRateLimits().forEach(r -> {
            if (r.getFilterKeyType() != null) {
                throw new FilterKeyTypeDeprectatedException();
            }
        });
        FilterConfiguration filterConfig = new FilterConfiguration();
        filterConfig.setUrl(config.getUrl());
        filterConfig.setOrder(config.getFilterOrder());
        filterConfig.setStrategy(config.getStrategy());
        filterConfig.setHttpResponseBody(config.getHttpResponseBody());
        filterConfig.setHttpResponseHeaders(config.getHttpResponseHeaders());
        filterConfig.setMetrics(config.getMetrics());
        this.throwExceptionOnInvalidFilterUrl(filterConfig);
        config.getRateLimits().forEach(rl -> {
            ConfigurationBuilder configurationBuilder = this.prepareBucket4jConfigurationBuilder((RateLimit)rl);
            RateLimitCheck rlc = (servletRequest, async) -> {
                boolean skipRateLimit = false;
                if (rl.getSkipCondition() != null) {
                    skipRateLimit = this.skipCondition((RateLimit)rl, expressionParser, (BeanFactory)beanFactory).evalute(servletRequest);
                }
                if (rl.getExecuteCondition() != null && !skipRateLimit) {
                    boolean bl = skipRateLimit = !this.executeCondition((RateLimit)rl, expressionParser, (BeanFactory)beanFactory).evalute(servletRequest);
                }
                if (!skipRateLimit) {
                    String key = this.getKeyFilter(filterConfig.getUrl(), (RateLimit)rl, expressionParser, (BeanFactory)beanFactory).key(servletRequest);
                    BucketConfiguration bucketConfiguration = configurationBuilder.build();
                    List<MetricTagResult> metricTagResults = this.getMetricTags(expressionParser, beanFactory, filterConfig, servletRequest);
                    MetricBucketListener metricBucketListener = new MetricBucketListener(config.getCacheName(), this.getMetricHandlers(), filterConfig.getMetrics().getTypes(), metricTagResults);
                    Bucket bucket = buckets.getProxy((Serializable)((Object)key), bucketConfiguration).toListenable((BucketListener)metricBucketListener);
                    if (async) {
                        return new ConsumptionProbeHolder(bucket.asAsync().tryConsumeAndReturnRemaining(1L));
                    }
                    return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining(1L));
                }
                return null;
            };
            filterConfig.getRateLimitChecks().add(rlc);
        });
        return filterConfig;
    }

    private void throwExceptionOnInvalidFilterUrl(FilterConfiguration<R> filterConfig) {
        try {
            Pattern.compile(filterConfig.getUrl());
            if (filterConfig.getUrl().equals("/*")) {
                throw new PatternSyntaxException(filterConfig.getUrl(), "/*", 0);
            }
        }
        catch (PatternSyntaxException exception) {
            throw new FilterURLInvalidException(filterConfig.getUrl(), exception.getDescription());
        }
    }

    private ConfigurationBuilder prepareBucket4jConfigurationBuilder(RateLimit rl) {
        ConfigurationBuilder configBuilder = Bucket4j.configurationBuilder();
        for (BandWidth bandWidth : rl.getBandwidths()) {
            Bandwidth bucket4jBandWidth = Bandwidth.simple((long)bandWidth.getCapacity(), (Duration)Duration.of(bandWidth.getTime(), bandWidth.getUnit()));
            if (bandWidth.getFixedRefillInterval() > 0L) {
                bucket4jBandWidth = Bandwidth.classic((long)bandWidth.getCapacity(), (Refill)Refill.intervally((long)bandWidth.getCapacity(), (Duration)Duration.of(bandWidth.getFixedRefillInterval(), bandWidth.getFixedRefillIntervalUnit())));
            }
            configBuilder = configBuilder.addLimit(bucket4jBandWidth);
        }
        return configBuilder;
    }

    private List<MetricTagResult> getMetricTags(ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory, FilterConfiguration<R> filterConfig, R servletRequest) {
        List<MetricTagResult> metricTagResults = filterConfig.getMetrics().getTags().stream().map(metricMetaTag -> {
            String expression = metricMetaTag.getExpression();
            if (StringUtils.isEmpty((Object)expression)) {
                throw new MissingMetricTagExpressionException(metricMetaTag.getKey());
            }
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)beanFactory));
            Expression expr = expressionParser.parseExpression(expression);
            String value = (String)expr.getValue((EvaluationContext)context, servletRequest, String.class);
            return new MetricTagResult(metricMetaTag.getKey(), value, metricMetaTag.getTypes());
        }).collect(Collectors.toList());
        if (metricTagResults == null) {
            metricTagResults = new ArrayList<MetricTagResult>();
        }
        return metricTagResults;
    }

    public KeyFilter<R> getKeyFilter(String url, RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        String expression = rateLimit.getExpression();
        if (StringUtils.isEmpty((Object)expression)) {
            throw new MissingKeyFilterExpressionException();
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        return request -> {
            Expression expr = expressionParser.parseExpression(rateLimit.getExpression());
            String value = (String)expr.getValue((EvaluationContext)context, request, String.class);
            return url + "-" + value;
        };
    }

    public Condition<R> skipCondition(RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (rateLimit.getSkipCondition() != null) {
            return request -> {
                Expression expr = expressionParser.parseExpression(rateLimit.getSkipCondition());
                Boolean value = (Boolean)expr.getValue((EvaluationContext)context, request, Boolean.class);
                return value;
            };
        }
        return null;
    }

    public Condition<R> executeCondition(RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (rateLimit.getExecuteCondition() != null) {
            return request -> {
                Expression expr = expressionParser.parseExpression(rateLimit.getExecuteCondition());
                Boolean value = (Boolean)expr.getValue((EvaluationContext)context, request, Boolean.class);
                return value;
            };
        }
        return null;
    }
}

