/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.servlet;

import com.giffing.bucket4j.spring.boot.starter.config.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.springboot.SpringBootActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.servlet.ServletRequestFilter;
import io.github.bucket4j.grid.jcache.JCache;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Filter.class, JCache.class})
@ConditionalOnProperty(prefix="bucket4j", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={SyncCacheResolver.class})
@Import(value={Bucket4jCacheConfiguration.class, SpringBootActuatorConfig.class})
@Order(value=-2147483648)
public class Bucket4JAutoConfigurationServletFilter
extends Bucket4JBaseConfiguration<HttpServletRequest>
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    private Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationServletFilter.class);
    private final Bucket4JBootProperties properties;
    private final ConfigurableBeanFactory beanFactory;
    private final GenericApplicationContext context;
    private final SyncCacheResolver cacheResolver;
    private final List<MetricHandler> metricHandlers;

    public Bucket4JAutoConfigurationServletFilter(Bucket4JBootProperties properties, ConfigurableBeanFactory beanFactory, GenericApplicationContext context, SyncCacheResolver cacheResolver, List<MetricHandler> metricHandlers) {
        this.properties = properties;
        this.beanFactory = beanFactory;
        this.context = context;
        this.cacheResolver = cacheResolver;
        this.metricHandlers = metricHandlers;
    }

    @Bean
    @Qualifier(value="SERVLET")
    public Bucket4jConfigurationHolder servletConfigurationHolder() {
        return new Bucket4jConfigurationHolder();
    }

    @Bean
    public ExpressionParser servletFilterExpressionParser() {
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        SpelExpressionParser parser = new SpelExpressionParser(config);
        return parser;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        AtomicInteger filterCount = new AtomicInteger(0);
        this.properties.getFilters().stream().filter(filter -> !StringUtils.isEmpty((Object)filter.getUrl()) && filter.getFilterMethod().equals((Object)FilterMethod.SERVLET)).forEach(filter -> {
            filterCount.incrementAndGet();
            FilterConfiguration filterConfig = this.buildFilterConfig((Bucket4JConfiguration)filter, this.cacheResolver.resolve(filter.getCacheName()), this.servletFilterExpressionParser(), this.beanFactory);
            this.servletConfigurationHolder().addFilterConfiguration(filter);
            this.context.registerBean("bucket4JServletRequestFilter" + filterCount, Filter.class, () -> new ServletRequestFilter((FilterConfiguration<HttpServletRequest>)filterConfig), new BeanDefinitionCustomizer[0]);
            this.log.info("create-servlet-filter;{};{};{}", new Object[]{filterCount, filter.getCacheName(), filter.getUrl()});
        });
    }

    @Override
    public List<MetricHandler> getMetricHandlers() {
        return this.metricHandlers;
    }
}

