/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.filter.reactive.gateway;

import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.reactive.ReactiveRateLimitException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringCloudGatewayRateLimitFilter
implements GlobalFilter,
Ordered {
    private FilterConfiguration<ServerHttpRequest> filterConfig;

    public SpringCloudGatewayRateLimitFilter(FilterConfiguration<ServerHttpRequest> filterConfig) {
        this.filterConfig = filterConfig;
    }

    public int getOrder() {
        return this.filterConfig.getOrder();
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        ArrayList<CompletionStage> rateLimitFutures = new ArrayList<CompletionStage>();
        if (request.getURI().getPath().matches(this.filterConfig.getUrl())) {
            for (RateLimitCheck rl : this.filterConfig.getRateLimitChecks()) {
                ConsumptionProbeHolder probeHolder = rl.rateLimit((Object)request, true);
                if (probeHolder == null || probeHolder.getConsumptionProbeCompletableFuture() == null) continue;
                CompletableFuture limitCheckingFuture = probeHolder.getConsumptionProbeCompletableFuture();
                rateLimitFutures.add(limitCheckingFuture.thenCompose(probe -> {
                    if (probe.isConsumed()) {
                        return CompletableFuture.completedFuture(probe.getRemainingTokens());
                    }
                    return CompletableFuture.completedFuture(null);
                }));
            }
            CompletableFuture reduced = rateLimitFutures.stream().reduce(null, (a1, b1) -> {
                if (a1 == null) {
                    return b1;
                }
                if (this.filterConfig.getStrategy().equals((Object)RateLimitConditionMatchingStrategy.FIRST)) {
                    return a1;
                }
                return a1.thenCombine((CompletionStage)b1, (x, y) -> {
                    if (x == null && y == null) {
                        return null;
                    }
                    if (x != null && y == null) {
                        return x;
                    }
                    if (x == null && y != null) {
                        return y;
                    }
                    return x < y ? x : y;
                });
            });
            Long remainingLimit = null;
            if (reduced != null) {
                remainingLimit = (Long)reduced.join();
            }
            if (remainingLimit == null || remainingLimit < 0L) {
                return Mono.error((Throwable)((Object)new ReactiveRateLimitException(this.filterConfig.getHttpResponseBody())));
            }
            if (remainingLimit != null) {
                response.getHeaders().set("X-Rate-Limit-Remaining", "" + remainingLimit);
            }
            return chain.filter(exchange);
        }
        return chain.filter(exchange);
    }
}

