/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public final class OriginSettingClient
extends FilterClient {
    private final String origin;
    private final boolean preserveResponseHeaders;

    public OriginSettingClient(Client in, String origin) {
        this(in, origin, false);
    }

    public OriginSettingClient(Client in, String origin, boolean preserveResponseHeaders) {
        super(in);
        this.origin = origin;
        this.preserveResponseHeaders = preserveResponseHeaders;
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        Supplier<ThreadContext.StoredContext> supplier = this.in().threadPool().getThreadContext().newRestorableContext(this.preserveResponseHeaders);
        try (ThreadContext.StoredContext ignore = this.in().threadPool().getThreadContext().stashWithOrigin(this.origin);){
            super.doExecute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }
}

