/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Map;
import java.util.Optional;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class NodeReplacementAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_replacement";
    static final Decision NO_REPLACEMENTS = Decision.single(Decision.Type.YES, "node_replacement", "neither the source nor target node are part of an ongoing node replacement (no replacements)", new Object[0]);

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return NO_REPLACEMENTS;
        }
        if (NodeReplacementAllocationDecider.replacementFromSourceToTarget(allocation, shardRouting.currentNodeId(), node.node().getName())) {
            return Decision.single(Decision.Type.YES, NAME, "node [%s] is replacing node [%s], and may receive shards from it", shardRouting.currentNodeId(), node.nodeId());
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, shardRouting.currentNodeId())) {
            return Decision.single(Decision.Type.NO, NAME, "node [%s] is being replaced, and its shards may only be allocated to the replacement target [%s]", shardRouting.currentNodeId(), NodeReplacementAllocationDecider.getReplacementName(allocation, shardRouting.currentNodeId()));
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, node.nodeId())) {
            return Decision.single(Decision.Type.NO, NAME, "node [%s] is being replaced by [%s], so no data may be allocated to it", node.nodeId(), NodeReplacementAllocationDecider.getReplacementName(allocation, node.nodeId()), shardRouting.currentNodeId());
        }
        if (NodeReplacementAllocationDecider.isReplacementTargetName(allocation, node.node().getName())) {
            SingleNodeShutdownMetadata shutdown = allocation.replacementTargetShutdowns().get(node.node().getName());
            return Decision.single(Decision.Type.NO, NAME, "node [%s] is replacing the vacating node [%s], only data currently allocated to the source node may be allocated to it until the replacement is complete", node.nodeId(), shutdown == null ? null : shutdown.getNodeId(), shardRouting.currentNodeId());
        }
        return Decision.single(Decision.Type.YES, NAME, "neither the source nor target node are part of an ongoing node replacement", new Object[0]);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return NO_REPLACEMENTS;
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, node.nodeId())) {
            return Decision.single(Decision.Type.NO, NAME, "node [%s] is being replaced by node [%s], so no data may remain on it", node.nodeId(), NodeReplacementAllocationDecider.getReplacementName(allocation, node.nodeId()));
        }
        return Decision.single(Decision.Type.YES, NAME, "node [%s] is not being replaced", node.nodeId());
    }

    @Override
    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return NO_REPLACEMENTS;
        }
        if (NodeReplacementAllocationDecider.isReplacementTargetName(allocation, node.getName())) {
            SingleNodeShutdownMetadata shutdown = allocation.replacementTargetShutdowns().get(node.getName());
            return Decision.single(Decision.Type.NO, NAME, "node [%s] is a node replacement target for node [%s], shards cannot auto expand to be on it until the replacement is complete", node.getId(), shutdown == null ? null : shutdown.getNodeId());
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, node.getId())) {
            return Decision.single(Decision.Type.NO, NAME, "node [%s] is being replaced by [%s], shards cannot auto expand to be on it", node.getId(), NodeReplacementAllocationDecider.getReplacementName(allocation, node.getId()));
        }
        return Decision.single(Decision.Type.YES, NAME, "node is not part of a node replacement, so shards may be auto expanded onto it", new Object[0]);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (NodeReplacementAllocationDecider.replacementFromSourceToTarget(allocation, shardRouting.currentNodeId(), node.node().getName())) {
            return Decision.single(Decision.Type.YES, NAME, "node [%s] is being replaced by node [%s], and can be force vacated to the target", shardRouting.currentNodeId(), node.nodeId());
        }
        return Decision.single(Decision.Type.NO, NAME, "shard is not on the source of a node replacement relocated to the replacement target", new Object[0]);
    }

    @Override
    public Decision canAllocateReplicaWhenThereIsRetentionLease(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (NodeReplacementAllocationDecider.isReplacementTargetName(allocation, node.node().getName())) {
            return Decision.single(Decision.Type.YES, NAME, "node [%s] is a node replacement target and can have a previously allocated replica re-allocated to it", node.nodeId());
        }
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static boolean replacementOngoing(RoutingAllocation allocation) {
        return !allocation.replacementTargetShutdowns().isEmpty();
    }

    private static boolean replacementFromSourceToTarget(RoutingAllocation allocation, String sourceNodeId, String targetNodeName) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return false;
        }
        if (sourceNodeId == null || targetNodeName == null) {
            return false;
        }
        SingleNodeShutdownMetadata shutdown = allocation.nodeShutdowns().get(sourceNodeId);
        return shutdown != null && shutdown.getType().equals((Object)SingleNodeShutdownMetadata.Type.REPLACE) && shutdown.getNodeId().equals(sourceNodeId) && shutdown.getTargetNodeName().equals(targetNodeName);
    }

    private static boolean isReplacementSource(RoutingAllocation allocation, String nodeId) {
        if (nodeId == null || !NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return false;
        }
        Map<String, SingleNodeShutdownMetadata> nodeShutdowns = allocation.nodeShutdowns();
        return nodeShutdowns.containsKey(nodeId) && nodeShutdowns.get(nodeId).getType().equals((Object)SingleNodeShutdownMetadata.Type.REPLACE);
    }

    private static boolean isReplacementTargetName(RoutingAllocation allocation, String nodeName) {
        if (nodeName == null || !NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return false;
        }
        return allocation.replacementTargetShutdowns().get(nodeName) != null;
    }

    private static String getReplacementName(RoutingAllocation allocation, String nodeIdBeingReplaced) {
        if (nodeIdBeingReplaced == null || !NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return null;
        }
        return Optional.ofNullable(allocation.nodeShutdowns().get(nodeIdBeingReplaced)).filter(shutdown -> shutdown.getType().equals((Object)SingleNodeShutdownMetadata.Type.REPLACE)).map(SingleNodeShutdownMetadata::getTargetNodeName).orElse(null);
    }
}

