/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.lang.reflect.Method;
import java.time.ZoneId;
import java.util.ArrayList;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.cron.CronExpression;
import org.jobrunr.scheduling.interval.Interval;
import org.jobrunr.spring.annotations.Recurring;
import org.jobrunr.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

public class RecurringJobPostProcessor
implements BeanPostProcessor,
EmbeddedValueResolverAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecurringJobPostProcessor.class);
    private final JobScheduler jobScheduler;
    private StringValueResolver embeddedValueResolver;
    private RecurringJobFinderMethodCallback recurringJobFinderMethodCallback;

    public RecurringJobPostProcessor(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)this.recurringJobFinderMethodCallback);
        return bean;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void afterPropertiesSet() {
        this.recurringJobFinderMethodCallback = new RecurringJobFinderMethodCallback(this.jobScheduler, this.embeddedValueResolver);
    }

    private static class RecurringJobFinderMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final JobScheduler jobScheduler;
        private final StringValueResolver embeddedValueResolver;

        public RecurringJobFinderMethodCallback(JobScheduler jobScheduler, StringValueResolver resolver) {
            this.jobScheduler = jobScheduler;
            this.embeddedValueResolver = resolver;
        }

        public void doWith(Method method) throws IllegalArgumentException {
            if (!method.isAnnotationPresent(Recurring.class)) {
                return;
            }
            if (this.hasParametersOutsideOfJobContext(method)) {
                throw new IllegalStateException("Methods annotated with " + Recurring.class.getName() + " can only have zero parameters or a single parameter of type JobContext.");
            }
            Recurring recurringAnnotation = method.getAnnotation(Recurring.class);
            String id = this.getId(recurringAnnotation);
            String cron = this.resolveStringValue(recurringAnnotation.cron());
            String interval = this.resolveStringValue(recurringAnnotation.interval());
            if (StringUtils.isNullOrEmpty((String)cron) && StringUtils.isNullOrEmpty((String)interval)) {
                throw new IllegalArgumentException("Either cron or interval attribute is required.");
            }
            if (StringUtils.isNotNullOrEmpty((String)cron) && StringUtils.isNotNullOrEmpty((String)interval)) {
                throw new IllegalArgumentException("Both cron and interval attribute provided. Only one is allowed.");
            }
            if ("-".equals(cron) || "-".equals(interval)) {
                if (id == null) {
                    LOGGER.warn("You are trying to disable a recurring job using placeholders but did not define an id.");
                } else {
                    this.jobScheduler.delete(id);
                }
            } else {
                JobDetails jobDetails = this.getJobDetails(method);
                ZoneId zoneId = this.getZoneId(recurringAnnotation);
                if (StringUtils.isNotNullOrEmpty((String)cron)) {
                    this.jobScheduler.scheduleRecurrently(id, jobDetails, (Schedule)CronExpression.create((String)cron), zoneId);
                } else {
                    this.jobScheduler.scheduleRecurrently(id, jobDetails, (Schedule)new Interval(interval), zoneId);
                }
            }
        }

        private boolean hasParametersOutsideOfJobContext(Method method) {
            if (method.getParameterCount() == 0) {
                return false;
            }
            if (method.getParameterCount() > 1) {
                return true;
            }
            return !method.getParameterTypes()[0].equals(JobContext.class);
        }

        private String getId(Recurring recurringAnnotation) {
            String id = this.resolveStringValue(recurringAnnotation.id());
            return StringUtils.isNullOrEmpty((String)id) ? null : id;
        }

        private JobDetails getJobDetails(Method method) {
            JobDetails jobDetails = new JobDetails(method.getDeclaringClass().getName(), null, method.getName(), new ArrayList());
            jobDetails.setCacheable(true);
            return jobDetails;
        }

        private ZoneId getZoneId(Recurring recurringAnnotation) {
            String zoneId = this.resolveStringValue(recurringAnnotation.zoneId());
            return StringUtils.isNullOrEmpty((String)zoneId) ? ZoneId.systemDefault() : ZoneId.of(zoneId);
        }

        private String resolveStringValue(String value) {
            if (this.embeddedValueResolver != null && value != null) {
                return this.embeddedValueResolver.resolveStringValue(value);
            }
            return value;
        }
    }
}

