/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jena.atlas.lib.BitsInt;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.NodeIdType;
import org.apache.jena.tdb2.store.value.DoubleNode62;

public final class NodeIdFactory {
    private static AtomicInteger counter = new AtomicInteger(176);

    private static NodeId create(NodeIdType type, int v1, long v2) {
        if (NodeIdType.isSpecial(type)) {
            if (NodeId.equals(NodeId.NodeDoesNotExist, v1, v2)) {
                return NodeId.NodeDoesNotExist;
            }
            if (NodeId.equals(NodeId.NodeIdAny, v1, v2)) {
                return NodeId.NodeIdAny;
            }
            if (NodeId.equals(NodeId.NodeIdDefined, v1, v2)) {
                return NodeId.NodeIdDefined;
            }
            if (NodeId.equals(NodeId.NodeIdDefined, v1, v2)) {
                return NodeId.NodeIdDefined;
            }
            if (NodeId.equals(NodeId.NodeIdUndefined, v1, v2)) {
                return NodeId.NodeIdUndefined;
            }
        }
        return NodeIdFactory.createNew(type, v1, v2);
    }

    public static NodeId createValue(NodeIdType type, long value) {
        return NodeIdFactory.createNew(type, 0, value);
    }

    private static NodeId createNew(NodeIdType type, int v1, long v2) {
        return NodeId.createRaw(type, v1, v2);
    }

    public static NodeId createPtr(long lo) {
        return NodeIdFactory.createNew(NodeIdType.PTR, 0, lo);
    }

    static NodeId createPtrLong(int hi, long lo) {
        return NodeIdFactory.create(NodeIdType.PTR, hi, lo);
    }

    private static NodeId create64(long value2) {
        if (!BitsLong.isSet((long)value2, (int)63)) {
            return NodeIdFactory.createPtr(value2);
        }
        long v2 = value2;
        if (BitsLong.isSet((long)v2, (int)62)) {
            v2 = DoubleNode62.removeType(v2);
            return NodeId.createRaw(NodeIdType.XSD_DOUBLE, v2);
        }
        int t = (int)BitsLong.unpack((long)v2, (int)56, (int)63);
        v2 = BitsLong.clear((long)v2, (int)56, (int)64);
        NodeIdType type = NodeIdType.intToEnum(t);
        if (type == NodeIdType.SPECIAL) {
            throw new TDBException(String.format("Attempt to create a special from a long: 0x%016", v2));
        }
        return NodeId.createRaw(type, v2);
    }

    private static NodeId create(int v1, long v2) {
        if (!BitsInt.isSet((int)v1, (int)32)) {
            return NodeIdFactory.createPtrLong(v1, v2);
        }
        int t = v1 >> 24;
        NodeIdType type = NodeIdType.intToEnum(t);
        if (type == NodeIdType.SPECIAL) {
            throw new TDBException(String.format("Attempt to create a special from a long: 0x%016", v2));
        }
        return NodeIdFactory.createNew(type, 0, v2);
    }

    public static NodeId get(byte[] b) {
        return NodeIdFactory.get(b, 0);
    }

    public static NodeId get(ByteBuffer b) {
        long value2 = b.getLong();
        return NodeIdFactory.decode(value2);
    }

    public static NodeId get(byte[] b, int idx) {
        long value2 = Bytes.getLong((byte[])b, (int)idx);
        return NodeIdFactory.decode(value2);
    }

    public static NodeId get(ByteBuffer b, int idx) {
        long value2 = b.getLong(idx);
        return NodeIdFactory.decode(value2);
    }

    private static NodeId decode(long value2) {
        return NodeIdFactory.create64(value2);
    }

    public static void set(NodeId nodeId, byte[] b) {
        long v2 = NodeIdFactory.encode(nodeId);
        Bytes.setLong((long)v2, (byte[])b, (int)0);
    }

    private static long encode(NodeId nodeId) {
        long x = nodeId.value2;
        switch (nodeId.type()) {
            case PTR: {
                return x;
            }
            case XSD_DOUBLE: {
                x = DoubleNode62.insertType(x);
                return x;
            }
        }
        x = BitsLong.pack((long)x, (long)nodeId.getTypeValue(), (int)56, (int)62);
        x = BitsLong.set((long)x, (int)63);
        return x;
    }

    public static void set(NodeId nodeId, ByteBuffer b) {
        long v2 = NodeIdFactory.encode(nodeId);
        b.putLong(v2);
    }

    public static void set(NodeId nodeId, byte[] b, int idx) {
        long v2 = NodeIdFactory.encode(nodeId);
        Bytes.setLong((long)v2, (byte[])b, (int)idx);
    }

    public static void set(NodeId nodeId, ByteBuffer b, int idx) {
        long v2 = NodeIdFactory.encode(nodeId);
        b.putLong(idx, v2);
    }

    public static void setNext(NodeId nodeId, byte[] b, int idx) {
        long v2 = NodeIdFactory.encode(nodeId);
        Bytes.setLong((long)(v2 + 1L), (byte[])b, (int)idx);
    }

    public static NodeId genUnique() {
        return NodeIdFactory.create(NodeIdType.SPECIAL, counter.incrementAndGet(), 0L);
    }
}

