/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.SignedIdentifiersWrapper;
import com.azure.storage.blob.implementation.models.ContainersAcquireLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersBreakLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersChangeLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersCreateResponse;
import com.azure.storage.blob.implementation.models.ContainersDeleteResponse;
import com.azure.storage.blob.implementation.models.ContainersGetAccessPolicyResponse;
import com.azure.storage.blob.implementation.models.ContainersGetAccountInfoResponse;
import com.azure.storage.blob.implementation.models.ContainersGetPropertiesResponse;
import com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.implementation.models.ContainersReleaseLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersRenewLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersRestoreResponse;
import com.azure.storage.blob.implementation.models.ContainersSetAccessPolicyResponse;
import com.azure.storage.blob.implementation.models.ContainersSetMetadataResponse;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.PublicAccessType;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class ContainersImpl {
    private ContainersService service;
    private AzureBlobStorageImpl client;

    public ContainersImpl(AzureBlobStorageImpl client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<ContainersCreateResponse> createWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        PublicAccessType access = null;
        String requestId = null;
        String restype = "container";
        String defaultEncryptionScope = null;
        Boolean encryptionScopeOverridePrevented = null;
        return this.service.create(containerName, this.client.getUrl(), timeout, metadata, access, this.client.getVersion(), requestId, "container", defaultEncryptionScope, encryptionScopeOverridePrevented, context);
    }

    public Mono<ContainersCreateResponse> createWithRestResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        String restype = "container";
        String defaultEncryptionScope = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScope = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        Boolean encryptionScopeOverridePrevented = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePrevented = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        return this.service.create(containerName, this.client.getUrl(), timeout, metadata, access, this.client.getVersion(), requestId, "container", defaultEncryptionScope, encryptionScopeOverridePrevented, context);
    }

    public Mono<ContainersGetPropertiesResponse> getPropertiesWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String requestId = null;
        String restype = "container";
        return this.service.getProperties(containerName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "container", context);
    }

    public Mono<ContainersGetPropertiesResponse> getPropertiesWithRestResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        return this.service.getProperties(containerName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "container", context);
    }

    public Mono<ContainersDeleteResponse> deleteWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String requestId = null;
        String restype = "container";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.delete(containerName, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "container", context);
    }

    public Mono<ContainersDeleteResponse> deleteWithRestResponseAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String restype = "container";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(containerName, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "container", context);
    }

    public Mono<ContainersSetMetadataResponse> setMetadataWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        Map<String, String> metadata = null;
        String requestId = null;
        String restype = "container";
        String comp = "metadata";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        return this.service.setMetadata(containerName, this.client.getUrl(), timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "container", "metadata", context);
    }

    public Mono<ContainersSetMetadataResponse> setMetadataWithRestResponseAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        String restype = "container";
        String comp = "metadata";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return this.service.setMetadata(containerName, this.client.getUrl(), timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "container", "metadata", context);
    }

    public Mono<ContainersGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String requestId = null;
        String restype = "container";
        String comp = "acl";
        return this.service.getAccessPolicy(containerName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "container", "acl", context);
    }

    public Mono<ContainersGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String comp = "acl";
        return this.service.getAccessPolicy(containerName, this.client.getUrl(), timeout, leaseId, this.client.getVersion(), requestId, "container", "acl", context);
    }

    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String leaseId = null;
        PublicAccessType access = null;
        String requestId = null;
        String restype = "container";
        String comp = "acl";
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(null);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setAccessPolicy(containerName, this.client.getUrl(), containerAclConverted, timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "container", "acl", context);
    }

    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String containerName, List<BlobSignedIdentifier> containerAcl, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String restype = "container";
        String comp = "acl";
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessPolicy(containerName, this.client.getUrl(), containerAclConverted, timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "container", "acl", context);
    }

    public Mono<ContainersRestoreResponse> restoreWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String deletedContainerName = null;
        String deletedContainerVersion = null;
        String restype = "container";
        String comp = "undelete";
        return this.service.restore(containerName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "container", "undelete", context);
    }

    public Mono<ContainersRestoreResponse> restoreWithRestResponseAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        String restype = "container";
        String comp = "undelete";
        return this.service.restore(containerName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "container", "undelete", context);
    }

    public Mono<ContainersAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Integer duration = null;
        String proposedLeaseId = null;
        String requestId = null;
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.acquireLease(containerName, this.client.getUrl(), timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "acquire", context);
    }

    public Mono<ContainersAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLease(containerName, this.client.getUrl(), timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "acquire", context);
    }

    public Mono<ContainersReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String containerName, String leaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "lease";
        String restype = "container";
        String action = "release";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.releaseLease(containerName, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "release", context);
    }

    public Mono<ContainersReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "release";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLease(containerName, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "release", context);
    }

    public Mono<ContainersRenewLeaseResponse> renewLeaseWithRestResponseAsync(String containerName, String leaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.renewLease(containerName, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "renew", context);
    }

    public Mono<ContainersRenewLeaseResponse> renewLeaseWithRestResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLease(containerName, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "renew", context);
    }

    public Mono<ContainersBreakLeaseResponse> breakLeaseWithRestResponseAsync(String containerName, Context context) {
        Integer timeout = null;
        Integer breakPeriod = null;
        String requestId = null;
        String comp = "lease";
        String restype = "container";
        String action = "break";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.breakLease(containerName, this.client.getUrl(), timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "break", context);
    }

    public Mono<ContainersBreakLeaseResponse> breakLeaseWithRestResponseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "break";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLease(containerName, this.client.getUrl(), timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "break", context);
    }

    public Mono<ContainersChangeLeaseResponse> changeLeaseWithRestResponseAsync(String containerName, String leaseId, String proposedLeaseId, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "lease";
        String restype = "container";
        String action = "change";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.changeLease(containerName, this.client.getUrl(), timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "change", context);
    }

    public Mono<ContainersChangeLeaseResponse> changeLeaseWithRestResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "change";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLease(containerName, this.client.getUrl(), timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "lease", "container", "change", context);
    }

    public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegmentWithRestResponseAsync(String containerName, Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String requestId = null;
        String restype = "container";
        String comp = "list";
        String includeConverted = null;
        return this.service.listBlobFlatSegment(containerName, this.client.getUrl(), prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "container", "list", context);
    }

    public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegmentWithRestResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobFlatSegment(containerName, this.client.getUrl(), prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "container", "list", context);
    }

    public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithRestResponseAsync(String containerName, String delimiter, Context context) {
        String prefix = null;
        String marker = null;
        Integer maxresults = null;
        Integer timeout = null;
        String requestId = null;
        String restype = "container";
        String comp = "list";
        String includeConverted = null;
        return this.service.listBlobHierarchySegment(containerName, this.client.getUrl(), prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "container", "list", context);
    }

    public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithRestResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobHierarchySegment(containerName, this.client.getUrl(), prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "container", "list", context);
    }

    public Mono<ContainersGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(String containerName, Context context) {
        String restype = "account";
        String comp = "properties";
        return this.service.getAccountInfo(containerName, this.client.getUrl(), this.client.getVersion(), "account", "properties", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageContainers")
    private static interface ContainersService {
        @Put(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersCreateResponse> create(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8, @HeaderParam(value="x-ms-default-encryption-scope") String var9, @HeaderParam(value="x-ms-deny-encryption-scope-override") Boolean var10, Context var11);

        @Get(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersGetPropertiesResponse> getProperties(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7, Context var8);

        @Delete(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersDeleteResponse> delete(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="restype") String var9, Context var10);

        @Put(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersSetMetadataResponse> setMetadata(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="restype") String var9, @QueryParam(value="comp") String var10, Context var11);

        @Get(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersGetAccessPolicyResponse> getAccessPolicy(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8, Context var9);

        @Put(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersSetAccessPolicyResponse> setAccessPolicy(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="restype") String var11, @QueryParam(value="comp") String var12, Context var13);

        @Put(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersRestoreResponse> restore(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="x-ms-deleted-container-name") String var6, @HeaderParam(value="x-ms-deleted-container-version") String var7, @QueryParam(value="restype") String var8, @QueryParam(value="comp") String var9, Context var10);

        @Put(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersAcquireLeaseResponse> acquireLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-duration") Integer var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="comp") String var10, @QueryParam(value="restype") String var11, @HeaderParam(value="x-ms-lease-action") String var12, Context var13);

        @Put(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersReleaseLeaseResponse> releaseLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @QueryParam(value="restype") String var10, @HeaderParam(value="x-ms-lease-action") String var11, Context var12);

        @Put(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersRenewLeaseResponse> renewLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @QueryParam(value="restype") String var10, @HeaderParam(value="x-ms-lease-action") String var11, Context var12);

        @Put(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersBreakLeaseResponse> breakLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-break-period") Integer var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @QueryParam(value="restype") String var10, @HeaderParam(value="x-ms-lease-action") String var11, Context var12);

        @Put(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersChangeLeaseResponse> changeLease(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-proposed-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="comp") String var10, @QueryParam(value="restype") String var11, @HeaderParam(value="x-ms-lease-action") String var12, Context var13);

        @Get(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegment(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="restype") String var10, @QueryParam(value="comp") String var11, Context var12);

        @Get(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegment(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="delimiter") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="include") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="restype") String var11, @QueryParam(value="comp") String var12, Context var13);

        @Get(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersGetAccountInfoResponse> getAccountInfo(@PathParam(value="containerName") String var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, Context var6);
    }
}

