/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Blob-GetProperties-Headers")
public final class BlobGetPropertiesHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-creation-time")
    private DateTimeRfc1123 creationTime;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="x-ms-or-policy-id")
    private String objectReplicationPolicyId;
    @HeaderCollection(value="x-ms-or-")
    private Map<String, String> objectReplicationRules;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType blobType;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-incremental-copy")
    private Boolean isIncrementalCopy;
    @JsonProperty(value="x-ms-copy-destination-snapshot")
    private String destinationSnapshot;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer blobCommittedBlockCount;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String encryptionKeySha256;
    @JsonProperty(value="x-ms-encryption-scope")
    private String encryptionScope;
    @JsonProperty(value="x-ms-access-tier")
    private String accessTier;
    @JsonProperty(value="x-ms-access-tier-inferred")
    private Boolean accessTierInferred;
    @JsonProperty(value="x-ms-archive-status")
    private String archiveStatus;
    @JsonProperty(value="x-ms-access-tier-change-time")
    private DateTimeRfc1123 accessTierChangeTime;
    @JsonProperty(value="x-ms-version-id")
    private String versionId;
    @JsonProperty(value="x-ms-is-current-version")
    private Boolean isCurrentVersion;
    @JsonProperty(value="x-ms-tag-count")
    private Long tagCount;
    @JsonProperty(value="x-ms-expiry-time")
    private DateTimeRfc1123 expiresOn;
    @JsonProperty(value="x-ms-blob-sealed")
    private Boolean isSealed;
    @JsonProperty(value="x-ms-rehydrate-priority")
    private String rehydratePriority;
    @JsonProperty(value="x-ms-last-access-time")
    private DateTimeRfc1123 lastAccessed;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public OffsetDateTime getCreationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.getDateTime();
    }

    public BlobGetPropertiesHeaders setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobGetPropertiesHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getObjectReplicationPolicyId() {
        return this.objectReplicationPolicyId;
    }

    public BlobGetPropertiesHeaders setObjectReplicationPolicyId(String objectReplicationPolicyId) {
        this.objectReplicationPolicyId = objectReplicationPolicyId;
        return this;
    }

    public Map<String, String> getObjectReplicationRules() {
        return this.objectReplicationRules;
    }

    public BlobGetPropertiesHeaders setObjectReplicationRules(Map<String, String> objectReplicationRules) {
        this.objectReplicationRules = objectReplicationRules;
        return this;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public BlobGetPropertiesHeaders setBlobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobGetPropertiesHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobGetPropertiesHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobGetPropertiesHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobGetPropertiesHeaders setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobGetPropertiesHeaders setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public BlobGetPropertiesHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    public BlobGetPropertiesHeaders setIsIncrementalCopy(Boolean isIncrementalCopy) {
        this.isIncrementalCopy = isIncrementalCopy;
        return this;
    }

    public String getDestinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobGetPropertiesHeaders setDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobGetPropertiesHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobGetPropertiesHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobGetPropertiesHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobGetPropertiesHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobGetPropertiesHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public BlobGetPropertiesHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobGetPropertiesHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobGetPropertiesHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobGetPropertiesHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobGetPropertiesHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobGetPropertiesHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public BlobGetPropertiesHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BlobGetPropertiesHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public BlobGetPropertiesHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobGetPropertiesHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public BlobGetPropertiesHeaders setBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public BlobGetPropertiesHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public BlobGetPropertiesHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobGetPropertiesHeaders setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public String getAccessTier() {
        return this.accessTier;
    }

    public BlobGetPropertiesHeaders setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public Boolean isAccessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobGetPropertiesHeaders setAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public String getArchiveStatus() {
        return this.archiveStatus;
    }

    public BlobGetPropertiesHeaders setArchiveStatus(String archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public BlobGetPropertiesHeaders setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public BlobGetPropertiesHeaders setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    public BlobGetPropertiesHeaders setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    public Long getTagCount() {
        return this.tagCount;
    }

    public BlobGetPropertiesHeaders setTagCount(Long tagCount) {
        this.tagCount = tagCount;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn.getDateTime();
    }

    public BlobGetPropertiesHeaders setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn == null ? null : new DateTimeRfc1123(expiresOn);
        return this;
    }

    public Boolean isSealed() {
        return this.isSealed;
    }

    public BlobGetPropertiesHeaders setIsSealed(Boolean isSealed) {
        this.isSealed = isSealed;
        return this;
    }

    public String getRehydratePriority() {
        return this.rehydratePriority;
    }

    public BlobGetPropertiesHeaders setRehydratePriority(String rehydratePriority) {
        this.rehydratePriority = rehydratePriority;
        return this;
    }

    public OffsetDateTime getLastAccessed() {
        if (this.lastAccessed == null) {
            return null;
        }
        return this.lastAccessed.getDateTime();
    }

    public BlobGetPropertiesHeaders setLastAccessed(OffsetDateTime lastAccessed) {
        this.lastAccessed = lastAccessed == null ? null : new DateTimeRfc1123(lastAccessed);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BlobGetPropertiesHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

