/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobRenewLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerRenewLeaseHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobLeaseRequestConditions;
import com.azure.storage.blob.options.BlobAcquireLeaseOptions;
import com.azure.storage.blob.options.BlobBreakLeaseOptions;
import com.azure.storage.blob.options.BlobChangeLeaseOptions;
import com.azure.storage.blob.options.BlobReleaseLeaseOptions;
import com.azure.storage.blob.options.BlobRenewLeaseOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class BlobLeaseAsyncClient {
    private final ClientLogger logger = new ClientLogger(BlobLeaseAsyncClient.class);
    private final boolean isBlob;
    private final String leaseId;
    private final AzureBlobStorageImpl client;
    private final String accountName;

    BlobLeaseAsyncClient(HttpPipeline pipeline, String url, String leaseId, boolean isBlob, String accountName, String serviceVersion) {
        this.isBlob = isBlob;
        this.leaseId = leaseId;
        this.client = new AzureBlobStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion).build();
        this.accountName = accountName;
    }

    public String getResourceUrl() {
        return this.client.getUrl();
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public Mono<String> acquireLease(int duration) {
        try {
            return this.acquireLeaseWithResponse(duration, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> acquireLeaseWithResponse(int duration, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.acquireLeaseWithResponse(new BlobAcquireLeaseOptions(duration).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> acquireLeaseWithResponse(BlobAcquireLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.acquireLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> acquireLeaseWithResponse(BlobAcquireLeaseOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().acquireLeaseWithRestResponseAsync(null, null, null, options.getDuration(), this.leaseId, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.containers().acquireLeaseWithRestResponseAsync(null, null, options.getDuration(), this.leaseId, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<String> renewLease() {
        try {
            return this.renewLeaseWithResponse((RequestConditions)null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> renewLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.renewLeaseWithResponse(new BlobRenewLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> renewLeaseWithResponse(BlobRenewLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.renewLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> renewLeaseWithResponse(BlobRenewLeaseOptions options, Context context) {
        options = options == null ? new BlobRenewLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().renewLeaseWithRestResponseAsync(null, null, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobRenewLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.containers().renewLeaseWithRestResponseAsync(null, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerRenewLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<Void> releaseLease() {
        try {
            return this.releaseLeaseWithResponse((RequestConditions)null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.releaseLeaseWithResponse(new BlobReleaseLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> releaseLeaseWithResponse(BlobReleaseLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.releaseLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> releaseLeaseWithResponse(BlobReleaseLeaseOptions options, Context context) {
        options = options == null ? new BlobReleaseLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().releaseLeaseWithRestResponseAsync(null, null, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
        }
        return this.client.containers().releaseLeaseWithRestResponseAsync(null, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Integer> breakLease() {
        try {
            return this.breakLeaseWithResponse((Integer)null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Integer>> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.breakLeaseWithResponse(new BlobBreakLeaseOptions().setBreakPeriod(breakPeriodInSeconds == null ? null : Duration.ofSeconds(breakPeriodInSeconds.intValue())).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Integer>> breakLeaseWithResponse(BlobBreakLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.breakLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Integer>> breakLeaseWithResponse(BlobBreakLeaseOptions options, Context context) {
        Integer breakPeriod;
        options = options == null ? new BlobBreakLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        Integer n = breakPeriod = options.getBreakPeriod() == null ? null : Integer.valueOf(Math.toIntExact(options.getBreakPeriod().getSeconds()));
        if (this.isBlob) {
            return this.client.blobs().breakLeaseWithRestResponseAsync(null, null, null, breakPeriod, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobBreakLeaseHeaders)rb.getDeserializedHeaders()).getLeaseTime()));
        }
        return this.client.containers().breakLeaseWithRestResponseAsync(null, null, breakPeriod, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerBreakLeaseHeaders)rb.getDeserializedHeaders()).getLeaseTime()));
    }

    public Mono<String> changeLease(String proposedId) {
        try {
            return this.changeLeaseWithResponse(proposedId, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(new BlobChangeLeaseOptions(proposedId).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> changeLeaseWithResponse(BlobChangeLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> changeLeaseWithResponse(BlobChangeLeaseOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().changeLeaseWithRestResponseAsync(null, null, this.leaseId, options.getProposedId(), null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.containers().changeLeaseWithRestResponseAsync(null, this.leaseId, options.getProposedId(), null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public String getAccountName() {
        return this.accountName;
    }
}

