/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.options.BlobAcquireLeaseOptions;
import com.azure.storage.blob.options.BlobBreakLeaseOptions;
import com.azure.storage.blob.options.BlobChangeLeaseOptions;
import com.azure.storage.blob.options.BlobReleaseLeaseOptions;
import com.azure.storage.blob.options.BlobRenewLeaseOptions;
import com.azure.storage.blob.specialized.BlobLeaseAsyncClient;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;

public final class BlobLeaseClient {
    private final BlobLeaseAsyncClient client;

    BlobLeaseClient(BlobLeaseAsyncClient client) {
        this.client = client;
    }

    public String getResourceUrl() {
        return this.client.getResourceUrl();
    }

    public String getLeaseId() {
        return this.client.getLeaseId();
    }

    public String acquireLease(int duration) {
        return (String)this.acquireLeaseWithResponse(duration, null, null, Context.NONE).getValue();
    }

    public Response<String> acquireLeaseWithResponse(int duration, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.acquireLeaseWithResponse(new BlobAcquireLeaseOptions(duration).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    public Response<String> acquireLeaseWithResponse(BlobAcquireLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.acquireLeaseWithResponse(options, context), (Duration)timeout);
    }

    public String renewLease() {
        return (String)this.renewLeaseWithResponse((RequestConditions)null, null, Context.NONE).getValue();
    }

    public Response<String> renewLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.renewLeaseWithResponse(new BlobRenewLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    public Response<String> renewLeaseWithResponse(BlobRenewLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.renewLeaseWithResponse(options, context), (Duration)timeout);
    }

    public void releaseLease() {
        this.releaseLeaseWithResponse((RequestConditions)null, null, Context.NONE);
    }

    public Response<Void> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.releaseLeaseWithResponse(new BlobReleaseLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    public Response<Void> releaseLeaseWithResponse(BlobReleaseLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.releaseLeaseWithResponse(options, context), (Duration)timeout);
    }

    public Integer breakLease() {
        return (Integer)this.breakLeaseWithResponse(null, null, null, Context.NONE).getValue();
    }

    public Response<Integer> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.breakLeaseWithResponse(new BlobBreakLeaseOptions().setBreakPeriod(breakPeriodInSeconds == null ? null : Duration.ofSeconds(breakPeriodInSeconds.intValue())).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    public Response<Integer> breakLeaseWithResponse(BlobBreakLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.breakLeaseWithResponse(options, context), (Duration)timeout);
    }

    public String changeLease(String proposedId) {
        return (String)this.changeLeaseWithResponse(proposedId, null, null, Context.NONE).getValue();
    }

    public Response<String> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.changeLeaseWithResponse(new BlobChangeLeaseOptions(proposedId).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    public Response<String> changeLeaseWithResponse(BlobChangeLeaseOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.changeLeaseWithResponse(options, context), (Duration)timeout);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }
}

