/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardFailure
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String node;
    private final ErrorCause reason;
    private final int shard;
    @Nullable
    private final String status;
    public static final JsonpDeserializer<ShardFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardFailure::setupShardFailureDeserializer);

    private ShardFailure(Builder builder) {
        this.index = builder.index;
        this.node = builder.node;
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.shard = ApiTypeHelper.requireNonNull(builder.shard, this, "shard");
        this.status = builder.status;
    }

    public static ShardFailure of(Function<Builder, ObjectBuilder<ShardFailure>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String node() {
        return this.node;
    }

    public final ErrorCause reason() {
        return this.reason;
    }

    public final int shard() {
        return this.shard;
    }

    @Nullable
    public final String status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        generator.writeKey("shard");
        generator.write(this.shard);
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
    }

    protected static void setupShardFailureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::reason, ErrorCause._DESERIALIZER, "reason");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardFailure> {
        @Nullable
        private String index;
        @Nullable
        private String node;
        private ErrorCause reason;
        private Integer shard;
        @Nullable
        private String status;

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public final Builder reason(ErrorCause value) {
            this.reason = value;
            return this;
        }

        public final Builder reason(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reason(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder shard(int value) {
            this.shard = value;
            return this;
        }

        public final Builder status(@Nullable String value) {
            this.status = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardFailure build() {
            this._checkSingleUse();
            return new ShardFailure(this);
        }
    }
}

