/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScore;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.ScoreFunctionBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ScriptScoreFunction
extends ScoreFunctionBase
implements FunctionScoreVariant {
    private final Script script;
    public static final JsonpDeserializer<ScriptScoreFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptScoreFunction::setupScriptScoreFunctionDeserializer);

    private ScriptScoreFunction(Builder builder) {
        super(builder);
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
    }

    public static ScriptScoreFunction of(Function<Builder, ObjectBuilder<ScriptScoreFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FunctionScore.Kind _functionScoreKind() {
        return FunctionScore.Kind.ScriptScore;
    }

    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
    }

    protected static void setupScriptScoreFunctionDeserializer(ObjectDeserializer<Builder> op) {
        ScoreFunctionBase.setupScoreFunctionBaseDeserializer(op);
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    public static class Builder
    extends ScoreFunctionBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptScoreFunction> {
        private Script script;

        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptScoreFunction build() {
            this._checkSingleUse();
            return new ScriptScoreFunction(this);
        }
    }
}

