/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mget;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiGetError
implements JsonpSerializable {
    private final ErrorCause error;
    private final String id;
    private final String index;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<MultiGetError> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiGetError::setupMultiGetErrorDeserializer);

    private MultiGetError(Builder builder) {
        this.error = ApiTypeHelper.requireNonNull(builder.error, this, "error");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.type = builder.type;
    }

    public static MultiGetError of(Function<Builder, ObjectBuilder<MultiGetError>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ErrorCause error() {
        return this.error;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error");
        this.error.serialize(generator, mapper);
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (this.type != null) {
            generator.writeKey("_type");
            generator.write(this.type);
        }
    }

    protected static void setupMultiGetErrorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MultiGetError> {
        private ErrorCause error;
        private String id;
        private String index;
        @Nullable
        private String type;

        public final Builder error(ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Deprecated
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiGetError build() {
            this._checkSingleUse();
            return new MultiGetError(this);
        }
    }
}

