/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.data_streams_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamsStatsItem
implements JsonpSerializable {
    private final int backingIndices;
    private final String dataStream;
    @Nullable
    private final String storeSize;
    private final int storeSizeBytes;
    private final long maximumTimestamp;
    public static final JsonpDeserializer<DataStreamsStatsItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamsStatsItem::setupDataStreamsStatsItemDeserializer);

    private DataStreamsStatsItem(Builder builder) {
        this.backingIndices = ApiTypeHelper.requireNonNull(builder.backingIndices, this, "backingIndices");
        this.dataStream = ApiTypeHelper.requireNonNull(builder.dataStream, this, "dataStream");
        this.storeSize = builder.storeSize;
        this.storeSizeBytes = ApiTypeHelper.requireNonNull(builder.storeSizeBytes, this, "storeSizeBytes");
        this.maximumTimestamp = ApiTypeHelper.requireNonNull(builder.maximumTimestamp, this, "maximumTimestamp");
    }

    public static DataStreamsStatsItem of(Function<Builder, ObjectBuilder<DataStreamsStatsItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int backingIndices() {
        return this.backingIndices;
    }

    public final String dataStream() {
        return this.dataStream;
    }

    @Nullable
    public final String storeSize() {
        return this.storeSize;
    }

    public final int storeSizeBytes() {
        return this.storeSizeBytes;
    }

    public final long maximumTimestamp() {
        return this.maximumTimestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("backing_indices");
        generator.write(this.backingIndices);
        generator.writeKey("data_stream");
        generator.write(this.dataStream);
        if (this.storeSize != null) {
            generator.writeKey("store_size");
            generator.write(this.storeSize);
        }
        generator.writeKey("store_size_bytes");
        generator.write(this.storeSizeBytes);
        generator.writeKey("maximum_timestamp");
        generator.write(this.maximumTimestamp);
    }

    protected static void setupDataStreamsStatsItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backingIndices, JsonpDeserializer.integerDeserializer(), "backing_indices");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::storeSize, JsonpDeserializer.stringDeserializer(), "store_size");
        op.add(Builder::storeSizeBytes, JsonpDeserializer.integerDeserializer(), "store_size_bytes");
        op.add(Builder::maximumTimestamp, JsonpDeserializer.longDeserializer(), "maximum_timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamsStatsItem> {
        private Integer backingIndices;
        private String dataStream;
        @Nullable
        private String storeSize;
        private Integer storeSizeBytes;
        private Long maximumTimestamp;

        public final Builder backingIndices(int value) {
            this.backingIndices = value;
            return this;
        }

        public final Builder dataStream(String value) {
            this.dataStream = value;
            return this;
        }

        public final Builder storeSize(@Nullable String value) {
            this.storeSize = value;
            return this;
        }

        public final Builder storeSizeBytes(int value) {
            this.storeSizeBytes = value;
            return this;
        }

        public final Builder maximumTimestamp(long value) {
            this.maximumTimestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamsStatsItem build() {
            this._checkSingleUse();
            return new DataStreamsStatsItem(this);
        }
    }
}

