/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.update_aliases;

import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.elasticsearch.indices.update_aliases.ActionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RemoveAction
implements ActionVariant,
JsonpSerializable {
    @Nullable
    private final String alias;
    private final List<String> aliases;
    @Nullable
    private final String index;
    private final List<String> indices;
    @Nullable
    private final Boolean mustExist;
    public static final JsonpDeserializer<RemoveAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveAction::setupRemoveActionDeserializer);

    private RemoveAction(Builder builder) {
        this.alias = builder.alias;
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.index = builder.index;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.mustExist = builder.mustExist;
    }

    public static RemoveAction of(Function<Builder, ObjectBuilder<RemoveAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Action.Kind _actionKind() {
        return Action.Kind.Remove;
    }

    @Nullable
    public final String alias() {
        return this.alias;
    }

    public final List<String> aliases() {
        return this.aliases;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final Boolean mustExist() {
        return this.mustExist;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alias != null) {
            generator.writeKey("alias");
            generator.write(this.alias);
        }
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.mustExist != null) {
            generator.writeKey("must_exist");
            generator.write(this.mustExist.booleanValue());
        }
    }

    protected static void setupRemoveActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alias, JsonpDeserializer.stringDeserializer(), "alias");
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::mustExist, JsonpDeserializer.booleanDeserializer(), "must_exist");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoveAction> {
        @Nullable
        private String alias;
        @Nullable
        private List<String> aliases;
        @Nullable
        private String index;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean mustExist;

        public final Builder alias(@Nullable String value) {
            this.alias = value;
            return this;
        }

        public final Builder aliases(List<String> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        public final Builder aliases(String value, String ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder mustExist(@Nullable Boolean value) {
            this.mustExist = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoveAction build() {
            this._checkSingleUse();
            return new RemoveAction(this);
        }
    }
}

