/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.authenticate;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ServiceToken
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<ServiceToken> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ServiceToken::setupServiceTokenDeserializer);

    private ServiceToken(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.type = builder.type;
    }

    public static ServiceToken of(Function<Builder, ObjectBuilder<ServiceToken>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    protected static void setupServiceTokenDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ServiceToken> {
        private String name;
        @Nullable
        private String type;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ServiceToken build() {
            this._checkSingleUse();
            return new ServiceToken(this);
        }
    }
}

