/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch._types.NodeAttributes;
import co.elastic.clients.elasticsearch.transform.get_transform_stats.Checkpointing;
import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformIndexerStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformStats
implements JsonpSerializable {
    private final Checkpointing checkpointing;
    private final String id;
    @Nullable
    private final NodeAttributes node;
    @Nullable
    private final String reason;
    private final String state;
    private final TransformIndexerStats stats;
    public static final JsonpDeserializer<TransformStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformStats::setupTransformStatsDeserializer);

    private TransformStats(Builder builder) {
        this.checkpointing = ApiTypeHelper.requireNonNull(builder.checkpointing, this, "checkpointing");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.node = builder.node;
        this.reason = builder.reason;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
    }

    public static TransformStats of(Function<Builder, ObjectBuilder<TransformStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Checkpointing checkpointing() {
        return this.checkpointing;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final NodeAttributes node() {
        return this.node;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    public final String state() {
        return this.state;
    }

    public final TransformIndexerStats stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("checkpointing");
        this.checkpointing.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        generator.writeKey("state");
        generator.write(this.state);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupTransformStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkpointing, Checkpointing._DESERIALIZER, "checkpointing");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::node, NodeAttributes._DESERIALIZER, "node");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state");
        op.add(Builder::stats, TransformIndexerStats._DESERIALIZER, "stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformStats> {
        private Checkpointing checkpointing;
        private String id;
        @Nullable
        private NodeAttributes node;
        @Nullable
        private String reason;
        private String state;
        private TransformIndexerStats stats;

        public final Builder checkpointing(Checkpointing value) {
            this.checkpointing = value;
            return this;
        }

        public final Builder checkpointing(Function<Checkpointing.Builder, ObjectBuilder<Checkpointing>> fn) {
            return this.checkpointing(fn.apply(new Checkpointing.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder node(@Nullable NodeAttributes value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.node(fn.apply(new NodeAttributes.Builder()).build());
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public final Builder state(String value) {
            this.state = value;
            return this;
        }

        public final Builder stats(TransformIndexerStats value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<TransformIndexerStats.Builder, ObjectBuilder<TransformIndexerStats>> fn) {
            return this.stats(fn.apply(new TransformIndexerStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformStats build() {
            this._checkSingleUse();
            return new TransformStats(this);
        }
    }
}

