/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EmailResult
implements JsonpSerializable {
    @Nullable
    private final String account;
    private final EmailResult message;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<EmailResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EmailResult::setupEmailResultDeserializer);

    private EmailResult(Builder builder) {
        this.account = builder.account;
        this.message = ApiTypeHelper.requireNonNull(builder.message, this, "message");
        this.reason = builder.reason;
    }

    public static EmailResult of(Function<Builder, ObjectBuilder<EmailResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String account() {
        return this.account;
    }

    public final EmailResult message() {
        return this.message;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.account != null) {
            generator.writeKey("account");
            generator.write(this.account);
        }
        generator.writeKey("message");
        this.message.serialize(generator, mapper);
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    protected static void setupEmailResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::account, JsonpDeserializer.stringDeserializer(), "account");
        op.add(Builder::message, _DESERIALIZER, "message");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EmailResult> {
        @Nullable
        private String account;
        private EmailResult message;
        @Nullable
        private String reason;

        public final Builder account(@Nullable String value) {
            this.account = value;
            return this;
        }

        public final Builder message(EmailResult value) {
            this.message = value;
            return this;
        }

        public final Builder message(Function<Builder, ObjectBuilder<EmailResult>> fn) {
            return this.message(fn.apply(new Builder()).build());
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EmailResult build() {
            this._checkSingleUse();
            return new EmailResult(this);
        }
    }
}

