/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.elasticsearch.watcher.SearchInputRequestDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchInput
implements InputVariant,
JsonpSerializable {
    private final List<String> extract;
    private final SearchInputRequestDefinition request;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<SearchInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchInput::setupSearchInputDeserializer);

    private SearchInput(Builder builder) {
        this.extract = ApiTypeHelper.unmodifiable(builder.extract);
        this.request = ApiTypeHelper.requireNonNull(builder.request, this, "request");
        this.timeout = builder.timeout;
    }

    public static SearchInput of(Function<Builder, ObjectBuilder<SearchInput>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Input.Kind _inputKind() {
        return Input.Kind.Search;
    }

    public final List<String> extract() {
        return this.extract;
    }

    public final SearchInputRequestDefinition request() {
        return this.request;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.extract)) {
            generator.writeKey("extract");
            generator.writeStartArray();
            for (String item0 : this.extract) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("request");
        this.request.serialize(generator, mapper);
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    protected static void setupSearchInputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::extract, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extract");
        op.add(Builder::request, SearchInputRequestDefinition._DESERIALIZER, "request");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchInput> {
        @Nullable
        private List<String> extract;
        private SearchInputRequestDefinition request;
        @Nullable
        private Time timeout;

        public final Builder extract(List<String> list) {
            this.extract = Builder._listAddAll(this.extract, list);
            return this;
        }

        public final Builder extract(String value, String ... values) {
            this.extract = Builder._listAdd(this.extract, value, values);
            return this;
        }

        public final Builder request(SearchInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<SearchInputRequestDefinition.Builder, ObjectBuilder<SearchInputRequestDefinition>> fn) {
            return this.request(fn.apply(new SearchInputRequestDefinition.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchInput build() {
            this._checkSingleUse();
            return new SearchInput(this);
        }
    }
}

