/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.ui.model.problems;

import java.util.List;
import org.jobrunr.dashboard.ui.model.problems.NewJobRunrVersionProblem;
import org.jobrunr.dashboard.ui.model.problems.ProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.Problems;
import org.jobrunr.server.dashboard.NewJobRunrVersionNotification;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.listeners.MetadataChangeListener;

public class NewJobRunrVersionProblemHandler
implements MetadataChangeListener,
ProblemHandler {
    private final Problems problems;
    private final StorageProvider storageProvider;
    private boolean isNewVersionAvailable;

    public NewJobRunrVersionProblemHandler(Problems problems, StorageProvider storageProvider) {
        this.problems = problems;
        this.storageProvider = storageProvider;
        this.storageProvider.addJobStorageOnChangeListener(this);
        this.onChange(storageProvider.getMetadata(NewJobRunrVersionNotification.class.getSimpleName()));
    }

    @Override
    public void dismiss() {
        throw new IllegalStateException("Problem of type 'new-jobrunr-version' cannot be dismissed.");
    }

    @Override
    public String listenForChangesOfMetadataName() {
        return NewJobRunrVersionNotification.class.getSimpleName();
    }

    @Override
    public void onChange(List<JobRunrMetadata> metadataList) {
        if (this.isNewJobRunrVersionAvailable(metadataList)) {
            JobRunrMetadata jobRunrMetadata = metadataList.get(0);
            this.problems.addProblem(new NewJobRunrVersionProblem(jobRunrMetadata.getValue()));
            this.isNewVersionAvailable = true;
        } else if (this.isJobRunrUpdatedToLatestVersion(metadataList)) {
            this.problems.removeProblemsOfType("new-jobrunr-version");
            this.isNewVersionAvailable = false;
        }
    }

    private boolean isJobRunrUpdatedToLatestVersion(List<JobRunrMetadata> metadataList) {
        return metadataList.isEmpty() && this.isNewVersionAvailable;
    }

    private boolean isNewJobRunrVersionAvailable(List<JobRunrMetadata> metadataList) {
        return !metadataList.isEmpty() && !this.isNewVersionAvailable;
    }
}

