/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.ui.model.problems;

import java.util.HashMap;
import java.util.Map;
import org.jobrunr.dashboard.ui.model.problems.CpuAllocationIrregularityProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.NewJobRunrVersionProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.ProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.Problems;
import org.jobrunr.dashboard.ui.model.problems.ScheduledJobsNotFoundProblemHandler;
import org.jobrunr.dashboard.ui.model.problems.SevereJobRunrExceptionProblemHandler;
import org.jobrunr.storage.StorageProvider;

public class ProblemsManager {
    private final StorageProvider storageProvider;
    private final Problems problems;
    private final Map<String, ProblemHandler> problemHandlers;

    public ProblemsManager(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        this.problems = new Problems();
        this.problemHandlers = this.initProblemHandlers();
    }

    private Map<String, ProblemHandler> initProblemHandlers() {
        HashMap<String, ProblemHandler> result = new HashMap<String, ProblemHandler>();
        result.put("jobs-not-found", new ScheduledJobsNotFoundProblemHandler(this.problems, this.storageProvider));
        result.put("severe-jobrunr-exception", new SevereJobRunrExceptionProblemHandler(this.problems, this.storageProvider));
        result.put("cpu-allocation-irregularity", new CpuAllocationIrregularityProblemHandler(this.problems, this.storageProvider));
        result.put("new-jobrunr-version", new NewJobRunrVersionProblemHandler(this.problems, this.storageProvider));
        return result;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public void dismissProblemOfType(String param) {
        if (!this.problemHandlers.containsKey(param)) {
            throw new IllegalArgumentException("Unknown problem of type '" + param + "'");
        }
        this.problemHandlers.get(param).dismiss();
    }
}

