/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import org.jobrunr.jobs.JobDetails;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.resilience.Lock;
import org.jobrunr.utils.resilience.Lockable;

public abstract class AbstractJob
implements Lockable {
    private final transient Lock locker = new Lock();
    private volatile int version;
    private String jobSignature;
    private String jobName;
    private JobDetails jobDetails;

    protected AbstractJob() {
    }

    protected AbstractJob(JobDetails jobDetails) {
        this(jobDetails, 0);
    }

    protected AbstractJob(JobDetails jobDetails, int version) {
        this();
        this.jobDetails = jobDetails;
        this.version = version;
        this.jobSignature = JobUtils.getJobSignature(jobDetails);
    }

    public abstract Object getId();

    public int getVersion() {
        return this.version;
    }

    synchronized int increaseVersion() {
        return ++this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public String getJobSignature() {
        return this.jobSignature;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobDetails getJobDetails() {
        return this.jobDetails;
    }

    @Override
    public Lock lock() {
        return this.locker.lock();
    }
}

