/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.states.EnqueuedState;
import org.jobrunr.jobs.states.ScheduledState;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.ScheduleExpressionType;

public class RecurringJob
extends AbstractJob {
    private String id;
    private String scheduleExpression;
    private String zoneId;
    private Instant createdAt;

    private RecurringJob() {
    }

    public RecurringJob(String id, JobDetails jobDetails, String scheduleExpression, String zoneId) {
        this(id, jobDetails, ScheduleExpressionType.getSchedule(scheduleExpression), ZoneId.of(zoneId));
    }

    public RecurringJob(String id, JobDetails jobDetails, Schedule schedule, ZoneId zoneId) {
        this(id, jobDetails, schedule, zoneId, Instant.now(Clock.system(zoneId)));
    }

    public RecurringJob(String id, JobDetails jobDetails, String scheduleExpression, String zoneId, String createdAt) {
        this(id, jobDetails, ScheduleExpressionType.getSchedule(scheduleExpression), ZoneId.of(zoneId), Instant.parse(createdAt));
    }

    public RecurringJob(String id, JobDetails jobDetails, Schedule schedule, ZoneId zoneId, Instant createdAt) {
        super(jobDetails);
        schedule.validateSchedule();
        this.id = this.validateAndSetId(id);
        this.zoneId = zoneId.getId();
        this.scheduleExpression = schedule.toString();
        this.createdAt = createdAt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    public Job toScheduledJob() {
        Instant nextRun = this.getNextRun();
        Job job = new Job(this.getJobDetails(), new ScheduledState(nextRun, this));
        job.setJobName(this.getJobName());
        job.setRecurringJobId(this.getId());
        return job;
    }

    public Job toEnqueuedJob() {
        Job job = new Job(this.getJobDetails(), new EnqueuedState());
        job.setJobName(this.getJobName());
        job.setRecurringJobId(this.getId());
        return job;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getNextRun() {
        return ScheduleExpressionType.getSchedule(this.scheduleExpression).next(this.createdAt, ZoneId.of(this.zoneId));
    }

    private String validateAndSetId(String input) {
        String result = Optional.ofNullable(input).orElse(this.getJobSignature().replace("$", "_"));
        if (!result.matches("[\\dA-Za-z-_(),.]+")) {
            throw new IllegalArgumentException("The id of a recurring job can only contain letters and numbers.");
        }
        return result;
    }

    public String toString() {
        return "RecurringJob{id=" + this.id + ", version='" + this.getVersion() + '\'' + ", identity='" + System.identityHashCode(this) + '\'' + ", jobSignature='" + this.getJobSignature() + '\'' + ", jobName='" + this.getJobName() + '\'' + '}';
    }
}

