/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.context;

import java.time.Instant;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobDashboardLogger {
    public static final String JOBRUNR_LOG_KEY = "jobRunrDashboardLog";
    private final JobDashboardLogLines logLines;

    public JobDashboardLogger(Job job) {
        this.logLines = this.initLogLines(job);
    }

    public void info(String infoMessage) {
        this.logLines.add(new JobDashboardLogLine(Level.INFO, infoMessage));
    }

    public void warn(String warnMessage) {
        this.logLines.add(new JobDashboardLogLine(Level.WARN, warnMessage));
    }

    public void error(String errorMessage) {
        this.logLines.add(new JobDashboardLogLine(Level.ERROR, errorMessage));
    }

    private JobDashboardLogLines initLogLines(Job job) {
        Map<String, Object> jobMetadata = job.getMetadata();
        String logKey = JobDashboardLogger.logKey(job.getJobStates().size());
        jobMetadata.putIfAbsent(logKey, new JobDashboardLogLines());
        return (JobDashboardLogLines)ReflectionUtils.cast(jobMetadata.get(logKey));
    }

    private static String logKey(int jobStateNbr) {
        return "jobRunrDashboardLog-" + jobStateNbr;
    }

    public static class JobDashboardLogLine {
        private Level level;
        private Instant logInstant;
        private String logMessage;

        protected JobDashboardLogLine() {
        }

        public JobDashboardLogLine(Level level, String logMessage) {
            this.level = level;
            this.logInstant = Instant.now();
            this.logMessage = logMessage;
        }

        public Level getLevel() {
            return this.level;
        }

        public Instant getLogInstant() {
            return this.logInstant;
        }

        public String getLogMessage() {
            return this.logMessage;
        }
    }

    public static class JobDashboardLogLines
    implements JobContext.Metadata {
        private ConcurrentLinkedQueue<JobDashboardLogLine> logLines = new ConcurrentLinkedQueue();

        public void add(JobDashboardLogLine line) {
            this.logLines.add(line);
        }

        public Queue<JobDashboardLogLine> getLogLines() {
            return this.logLines;
        }
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

