/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.context;

import java.util.Map;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobDashboardProgressBar {
    public static final String JOBRUNR_PROGRESSBAR_KEY = "jobRunrDashboardProgressBar";
    private final JobDashboardProgress jobDashboardProgress;

    public JobDashboardProgressBar(Job job, Long totalAmount) {
        this.jobDashboardProgress = this.initJobDashboardProgress(job, totalAmount);
    }

    private JobDashboardProgress initJobDashboardProgress(Job job, Long totalAmount) {
        Map<String, Object> jobMetadata = job.getMetadata();
        String progressBarKey = JobDashboardProgressBar.progressBarKey(job.getJobStates().size());
        jobMetadata.putIfAbsent(progressBarKey, new JobDashboardProgress(totalAmount));
        return (JobDashboardProgress)ReflectionUtils.cast(jobMetadata.get(progressBarKey));
    }

    public void increaseByOne() {
        this.jobDashboardProgress.increaseByOne();
    }

    public int getProgress() {
        return this.jobDashboardProgress.getProgress();
    }

    public void setValue(int currentProgress) {
        this.setValue((long)currentProgress);
    }

    public void setValue(long currentProgress) {
        this.jobDashboardProgress.setCurrentValue(currentProgress);
    }

    private static String progressBarKey(int jobStateNbr) {
        return "jobRunrDashboardProgressBar-" + jobStateNbr;
    }

    private static class JobDashboardProgress
    implements JobContext.Metadata {
        private Long totalAmount;
        private Long currentValue;
        private int progress;

        protected JobDashboardProgress() {
        }

        public JobDashboardProgress(Long totalAmount) {
            if (totalAmount < 1L) {
                throw new IllegalArgumentException("The total progress amount must be larger than 0.");
            }
            this.totalAmount = totalAmount;
            this.currentValue = 0L;
        }

        public void increaseByOne() {
            this.setCurrentValue(this.currentValue + 1L);
        }

        public void setCurrentValue(Long currentValue) {
            this.currentValue = currentValue;
            this.progress = (int)(currentValue * 100L / this.totalAmount);
        }

        public int getProgress() {
            return this.progress;
        }
    }
}

