/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.details.JobDetailsAsmGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.lambdas.IocJobLambda;
import org.jobrunr.jobs.lambdas.IocJobLambdaFromStream;
import org.jobrunr.jobs.lambdas.JobLambda;
import org.jobrunr.jobs.lambdas.JobLambdaFromStream;
import org.jobrunr.jobs.lambdas.JobRunrJob;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class CachingJobDetailsGenerator
implements JobDetailsGenerator {
    private final JobDetailsGenerator delegate;
    private final Map<Class<?>, CacheableJobDetails> cache;

    public CachingJobDetailsGenerator() {
        this(new JobDetailsAsmGenerator());
    }

    public CachingJobDetailsGenerator(JobDetailsGenerator delegate) {
        this.delegate = delegate;
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public JobDetails toJobDetails(JobLambda lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableJobDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getJobDetails(lambda);
    }

    @Override
    public JobDetails toJobDetails(IocJobLambda<?> lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableJobDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getJobDetails(lambda);
    }

    @Override
    public <T> JobDetails toJobDetails(T itemFromStream, JobLambdaFromStream<T> lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableJobDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getJobDetails(itemFromStream, lambda);
    }

    @Override
    public <S, T> JobDetails toJobDetails(T itemFromStream, IocJobLambdaFromStream<S, T> lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableJobDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getJobDetails(itemFromStream, lambda);
    }

    private static class ItemFromStreamJobParameterRetriever
    implements JobParameterRetriever {
        private final String jobParameterClassName;

        public ItemFromStreamJobParameterRetriever(JobParameter jobParameter) {
            this.jobParameterClassName = jobParameter.getClassName();
        }

        @Override
        public <T> JobParameter getJobParameter(JobRunrJob job, Optional<T> itemFromStream) {
            return new JobParameter(this.jobParameterClassName, itemFromStream.orElseThrow(() -> JobRunrException.shouldNotHappenException("Can not find itemFromStream")));
        }
    }

    private static class MethodHandleJobParameterRetriever
    implements JobParameterRetriever {
        private final String jobParameterClassName;
        private final MethodHandle methodHandle;

        public MethodHandleJobParameterRetriever(JobParameter jobParameter, MethodHandle methodHandle) {
            this.jobParameterClassName = jobParameter.getClassName();
            this.methodHandle = methodHandle;
        }

        @Override
        public <T> JobParameter getJobParameter(JobRunrJob job, Optional<T> itemFromStream) {
            try {
                Object o = this.methodHandle.invokeExact(job);
                return new JobParameter(this.jobParameterClassName, o);
            }
            catch (Throwable throwable) {
                throw JobRunrException.shouldNotHappenException(throwable);
            }
        }
    }

    private static class FixedJobParameterRetriever
    implements JobParameterRetriever {
        private final JobParameter jobParameter;

        public FixedJobParameterRetriever(JobParameter jobParameter) {
            this.jobParameter = jobParameter;
        }

        @Override
        public <T> JobParameter getJobParameter(JobRunrJob job, Optional<T> itemFromStream) {
            return this.jobParameter;
        }
    }

    private static interface JobParameterRetriever {
        public <T> JobParameter getJobParameter(JobRunrJob var1, Optional<T> var2);
    }

    private static class CacheableJobDetails {
        private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
        private final JobDetailsGenerator jobDetailsGeneratorDelegate;
        private final ReentrantLock jobDetailsLock;
        private JobDetails jobDetails;
        private List<JobParameterRetriever> jobParameterRetrievers;

        private CacheableJobDetails(JobDetailsGenerator jobDetailsGeneratorDelegate) {
            this.jobDetailsGeneratorDelegate = jobDetailsGeneratorDelegate;
            this.jobDetailsLock = new ReentrantLock();
        }

        public JobDetails getJobDetails(JobLambda lambda) {
            if (this.jobDetails == null) {
                this.jobDetailsLock.lock();
                try {
                    this.jobDetails = this.jobDetailsGeneratorDelegate.toJobDetails(lambda);
                    this.jobParameterRetrievers = CacheableJobDetails.initJobParameterRetrievers(this.jobDetails, lambda, Optional.empty());
                    JobDetails jobDetails = this.jobDetails;
                    return jobDetails;
                }
                finally {
                    this.jobDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.jobDetails.getCacheable())) {
                return this.getCachedJobDetails(lambda, Optional.empty());
            }
            return this.jobDetailsGeneratorDelegate.toJobDetails(lambda);
        }

        public JobDetails getJobDetails(IocJobLambda lambda) {
            if (this.jobDetails == null) {
                this.jobDetailsLock.lock();
                try {
                    this.jobDetails = this.jobDetailsGeneratorDelegate.toJobDetails(lambda);
                    this.jobParameterRetrievers = CacheableJobDetails.initJobParameterRetrievers(this.jobDetails, lambda, Optional.empty());
                    JobDetails jobDetails = this.jobDetails;
                    return jobDetails;
                }
                finally {
                    this.jobDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.jobDetails.getCacheable())) {
                return this.getCachedJobDetails(lambda, Optional.empty());
            }
            return this.jobDetailsGeneratorDelegate.toJobDetails(lambda);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> JobDetails getJobDetails(T itemFromStream, JobLambdaFromStream<T> lambda) {
            if (this.jobDetails == null) {
                this.jobDetailsLock.lock();
                try {
                    this.jobDetails = this.jobDetailsGeneratorDelegate.toJobDetails(itemFromStream, lambda);
                    this.jobParameterRetrievers = CacheableJobDetails.initJobParameterRetrievers(this.jobDetails, lambda, Optional.of(itemFromStream));
                    JobDetails jobDetails = this.jobDetails;
                    return jobDetails;
                }
                finally {
                    this.jobDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.jobDetails.getCacheable())) {
                return this.getCachedJobDetails(lambda, Optional.of(itemFromStream));
            }
            return this.jobDetailsGeneratorDelegate.toJobDetails(itemFromStream, lambda);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S, T> JobDetails getJobDetails(T itemFromStream, IocJobLambdaFromStream<S, T> lambda) {
            if (this.jobDetails == null) {
                this.jobDetailsLock.lock();
                try {
                    this.jobDetails = this.jobDetailsGeneratorDelegate.toJobDetails(itemFromStream, lambda);
                    this.jobParameterRetrievers = CacheableJobDetails.initJobParameterRetrievers(this.jobDetails, lambda, Optional.of(itemFromStream));
                    JobDetails jobDetails = this.jobDetails;
                    return jobDetails;
                }
                finally {
                    this.jobDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.jobDetails.getCacheable())) {
                return this.getCachedJobDetails(lambda, Optional.of(itemFromStream));
            }
            return this.jobDetailsGeneratorDelegate.toJobDetails(itemFromStream, lambda);
        }

        private static <T> List<JobParameterRetriever> initJobParameterRetrievers(JobDetails jobDetails, JobRunrJob jobRunrJob, Optional<T> itemFromStream) {
            try {
                ArrayList<JobParameterRetriever> parameterRetrievers = new ArrayList<JobParameterRetriever>();
                ArrayList<Field> declaredFields = new ArrayList<Field>(Arrays.asList(jobRunrJob.getClass().getDeclaredFields()));
                List<JobParameter> jobParameters = jobDetails.getJobParameters();
                if (!declaredFields.isEmpty() && !((Field)declaredFields.get(0)).getType().getName().startsWith("java.") && (jobRunrJob instanceof JobLambda || jobRunrJob instanceof JobLambdaFromStream)) {
                    declaredFields.remove(0);
                }
                for (JobParameter jp : jobParameters) {
                    parameterRetrievers.add(CacheableJobDetails.createJobParameterRetriever(jp, jobRunrJob, itemFromStream, declaredFields));
                }
                jobDetails.setCacheable(declaredFields.isEmpty() && jobParameters.size() == parameterRetrievers.size());
                return parameterRetrievers;
            }
            catch (Exception e) {
                jobDetails.setCacheable(false);
                return Collections.emptyList();
            }
        }

        private static <T> JobParameterRetriever createJobParameterRetriever(JobParameter jp, JobRunrJob jobRunrJob, Optional<T> itemFromStream, List<Field> declaredFields) throws IllegalAccessException {
            JobParameterRetriever jobParameterRetriever = new FixedJobParameterRetriever(jp);
            if (itemFromStream.isPresent() && jp.getObject().equals(itemFromStream.get())) {
                jobParameterRetriever = new ItemFromStreamJobParameterRetriever(jp);
            } else {
                ListIterator<Field> fieldIterator = declaredFields.listIterator();
                while (fieldIterator.hasNext()) {
                    Field f = fieldIterator.next();
                    Object valueFromField = ReflectionUtils.getValueFromField(f, jobRunrJob);
                    if (!jp.getObject().equals(valueFromField)) continue;
                    MethodHandle e = lookup.unreflectGetter(f);
                    jobParameterRetriever = new MethodHandleJobParameterRetriever(jp, e.asType(e.type().generic()));
                    fieldIterator.remove();
                    break;
                }
            }
            return jobParameterRetriever;
        }

        private <T> JobDetails getCachedJobDetails(JobRunrJob job, Optional<T> itemFromStream) {
            JobDetails cachedJobDetails = new JobDetails(this.jobDetails.getClassName(), this.jobDetails.getStaticFieldName(), this.jobDetails.getMethodName(), this.jobParameterRetrievers.stream().map(jobParameterRetriever -> jobParameterRetriever.getJobParameter(job, itemFromStream)).collect(Collectors.toList()));
            cachedJobDetails.setCacheable(true);
            return cachedJobDetails;
        }
    }
}

