/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details;

import java.io.InputStream;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.jobrunr.jobs.details.AbstractJobDetailsFinder;
import org.jobrunr.jobs.details.JavaJobDetailsBuilder;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.jobs.lambdas.JobRunrJob;
import org.jobrunr.utils.StringUtils;

public class JavaJobDetailsFinder
extends AbstractJobDetailsFinder {
    private final JobRunrJob jobRunrJob;
    private final SerializedLambda serializedLambda;
    private final boolean isLambda;

    JavaJobDetailsFinder(JobRunrJob jobRunrJob, SerializedLambda serializedLambda, Object ... params) {
        super(new JavaJobDetailsBuilder(serializedLambda, params));
        this.jobRunrJob = jobRunrJob;
        this.serializedLambda = serializedLambda;
        boolean bl = this.isLambda = serializedLambda.getImplMethodName().startsWith("lambda$") || serializedLambda.getImplMethodName().contains("$lambda-");
        if (this.isLambda) {
            this.parse(this.getClassContainingLambdaAsInputStream());
        } else if (serializedLambda.getCapturedArgCount() == 1 && Arrays.stream(serializedLambda.getCapturedArg(0).getClass().getAnnotations()).anyMatch(ann -> "kotlin.Metadata".equals(ann.annotationType().getName()))) {
            this.jobDetailsBuilder.setClassName(serializedLambda.getCapturedArg(0).getClass().getName());
            this.jobDetailsBuilder.setMethodName(serializedLambda.getImplMethodName().contains("$") ? StringUtils.substringAfter(serializedLambda.getImplMethodName(), "$") : serializedLambda.getImplMethodName());
        }
    }

    @Override
    protected boolean isLambdaContainingJobDetails(String name) {
        return this.isLambda && name.equals(this.serializedLambda.getImplMethodName());
    }

    @Override
    protected InputStream getClassContainingLambdaAsInputStream() {
        return JobDetailsGeneratorUtils.getJavaClassContainingLambdaAsInputStream(this.jobRunrJob);
    }
}

