/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.details.instructions.AbstractJVMInstruction;
import org.jobrunr.jobs.details.postprocess.CGLibPostProcessor;
import org.jobrunr.jobs.details.postprocess.JobDetailsPostProcessor;

public abstract class JobDetailsBuilder {
    private final LinkedList<AbstractJVMInstruction> instructions = new LinkedList();
    private final LinkedList<Object> stack = new LinkedList();
    private final List<Object> localVariables;
    private String jobDetailsClassName;
    private String jobDetailsStaticFieldName;
    private String jobDetailsMethodName;
    private List<JobParameter> jobDetailsJobParameters;
    private List<JobDetailsPostProcessor> jobDetailsPostProcessors;

    protected JobDetailsBuilder(List<Object> localVariables) {
        this(localVariables, null, null);
    }

    protected JobDetailsBuilder(List<Object> localVariables, String className, String methodName) {
        this.localVariables = localVariables;
        this.setClassName(className);
        this.setMethodName(methodName);
        this.setJobParameters(new ArrayList<JobParameter>());
        this.jobDetailsPostProcessors = Collections.singletonList(new CGLibPostProcessor());
    }

    public void pushInstructionOnStack(AbstractJVMInstruction jvmInstruction) {
        this.instructions.add(jvmInstruction);
    }

    public Object getLocalVariable(int nbrInStack) {
        if (nbrInStack < this.localVariables.size()) {
            return this.localVariables.get(nbrInStack);
        }
        throw JobRunrException.shouldNotHappenException("Can not find variable " + nbrInStack + " in stack");
    }

    public void addLocalVariable(Object o) {
        this.localVariables.add(o);
    }

    public List<AbstractJVMInstruction> getInstructions() {
        return this.instructions;
    }

    public AbstractJVMInstruction pollFirstInstruction() {
        return this.instructions.pollFirst();
    }

    public LinkedList<Object> getStack() {
        return this.stack;
    }

    public JobDetails getJobDetails() {
        this.invokeInstructions();
        JobDetails jobDetails = new JobDetails(this.jobDetailsClassName, this.jobDetailsStaticFieldName, this.jobDetailsMethodName, this.jobDetailsJobParameters);
        return this.postProcessJobDetails(jobDetails);
    }

    private JobDetails postProcessJobDetails(JobDetails jobDetails) {
        JobDetails currentJobDetails = jobDetails;
        for (JobDetailsPostProcessor postProcessor : this.getJobDetailsPostProcessors()) {
            currentJobDetails = postProcessor.postProcess(currentJobDetails);
        }
        return currentJobDetails;
    }

    private void invokeInstructions() {
        if (this.instructions.isEmpty() && this.localVariables.size() > 1) {
            for (int i = 1; i < this.localVariables.size(); ++i) {
                Object variable = this.localVariables.get(i);
                this.jobDetailsJobParameters.add(new JobParameter(variable));
            }
        } else {
            AbstractJVMInstruction instruction = this.pollFirstInstruction();
            while (instruction != null) {
                instruction.invokeInstructionAndPushOnStack();
                instruction = this.pollFirstInstruction();
            }
        }
    }

    public void setClassName(String className) {
        if (this.jobDetailsStaticFieldName == null) {
            this.jobDetailsClassName = className;
        }
    }

    public void setStaticFieldName(String name) {
        this.jobDetailsStaticFieldName = name;
    }

    public void setMethodName(String name) {
        this.jobDetailsMethodName = name;
    }

    public void setJobParameters(List<JobParameter> jobParameters) {
        this.jobDetailsJobParameters = jobParameters;
    }

    List<JobDetailsPostProcessor> getJobDetailsPostProcessors() {
        return this.jobDetailsPostProcessors;
    }
}

