/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Optional;
import org.jobrunr.jobs.details.AbstractJobDetailsFinder;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.jobs.details.KotlinJobDetailsBuilder;
import org.jobrunr.jobs.lambdas.JobRunrJob;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.objectweb.asm.AnnotationVisitor;

public class KotlinJobDetailsFinder
extends AbstractJobDetailsFinder {
    private static final String INVOKE = "invoke";
    private static final String ACCEPT = "accept";
    private static final String RUN = "run";
    private final JobRunrJob jobRunrJob;
    private int methodCounter = 0;
    private KotlinVersion kotlinVersion;
    private String nestedKotlinClassWithMethodReference;

    KotlinJobDetailsFinder(JobRunrJob jobRunrJob, Object ... params) {
        super(new KotlinJobDetailsBuilder(jobRunrJob, params));
        this.jobRunrJob = jobRunrJob;
        this.parse(this.getClassContainingLambdaAsInputStream());
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return new AnnotationVisitor(458752){

            public void visit(String name, Object value) {
                if ("mv".equals(name)) {
                    int[] version = (int[])ReflectionUtils.cast(value);
                    if (version[0] == 1 && version[1] == 4) {
                        KotlinJobDetailsFinder.this.kotlinVersion = KotlinVersion.ONE_FOUR;
                    } else if (version[0] == 1 && version[1] == 5) {
                        KotlinJobDetailsFinder.this.kotlinVersion = KotlinVersion.ONE_FIVE;
                    } else if (version[0] == 1 && version[1] == 6) {
                        KotlinJobDetailsFinder.this.kotlinVersion = KotlinVersion.ONE_SIX;
                    } else {
                        throw new UnsupportedOperationException("The Kotlin version " + version[0] + "." + version[1] + " is unsupported");
                    }
                }
            }
        };
    }

    @Override
    protected boolean isLambdaContainingJobDetails(String name) {
        if (name.equals(ACCEPT) || name.equals(INVOKE)) {
            ++this.methodCounter;
        }
        if (KotlinVersion.ONE_FOUR.equals((Object)this.kotlinVersion)) {
            return name.equals(RUN) || (name.equals(ACCEPT) || name.equals(INVOKE)) && this.methodCounter == 2;
        }
        return name.equals(RUN) || (name.equals(ACCEPT) || name.equals(INVOKE)) && this.methodCounter == 1;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (access == 4120 || access == 4096) {
            this.nestedKotlinClassWithMethodReference = name;
        }
    }

    @Override
    protected InputStream getClassContainingLambdaAsInputStream() {
        return JobDetailsGeneratorUtils.getKotlinClassContainingLambdaAsInputStream(this.jobRunrJob);
    }

    @Override
    protected void parse(InputStream inputStream) {
        Optional<Field> field = ReflectionUtils.findField(this.jobRunrJob.getClass(), "function");
        if (field.isPresent()) {
            this.getJobDetailsFromKotlinFunction(field.get());
        } else {
            super.parse(inputStream);
            this.parseNestedClassIfItIsAMethodReference();
        }
    }

    private void getJobDetailsFromKotlinFunction(Field field) {
        Object function = ReflectionUtils.getValueFromField(field, this.jobRunrJob);
        Field receiver = ReflectionUtils.getField(function.getClass(), "receiver");
        Field name = ReflectionUtils.getField(function.getClass(), "name");
        Class<?> receiverClass = ReflectionUtils.getValueFromField(receiver, function).getClass();
        String methodName = (String)ReflectionUtils.cast(ReflectionUtils.getValueFromField(name, function));
        this.jobDetailsBuilder.setClassName(receiverClass.getName());
        this.jobDetailsBuilder.setMethodName(methodName);
    }

    private void parseNestedClassIfItIsAMethodReference() {
        boolean isNestedKotlinClassWithMethodReference;
        boolean bl = isNestedKotlinClassWithMethodReference = this.nestedKotlinClassWithMethodReference != null && !JobDetailsGeneratorUtils.toFQResource(this.jobRunrJob.getClass().getName()).equals(this.nestedKotlinClassWithMethodReference);
        if (isNestedKotlinClassWithMethodReference) {
            String location = "/" + this.nestedKotlinClassWithMethodReference + ".class";
            super.parse(this.jobRunrJob.getClass().getResourceAsStream(location));
            while (this.jobDetailsBuilder.getInstructions().size() > 1) {
                this.jobDetailsBuilder.pollFirstInstruction();
            }
        }
    }

    private static enum KotlinVersion {
        ONE_FOUR,
        ONE_FIVE,
        ONE_SIX;

    }
}

