/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details.instructions;

import java.util.List;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.details.JobDetailsBuilder;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.jobs.details.instructions.AbstractJVMInstruction;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.objectweb.asm.Handle;

public class InvokeDynamicInstruction
extends AbstractJVMInstruction {
    private String name;
    private String descriptor;
    private Handle bootstrapMethodHandle;
    private Object[] bootstrapMethodArguments;

    public InvokeDynamicInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    public void load(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.jobDetailsBuilder.pushInstructionOnStack(this);
        this.name = name;
        this.descriptor = descriptor;
        this.bootstrapMethodHandle = bootstrapMethodHandle;
        this.bootstrapMethodArguments = bootstrapMethodArguments;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Handle getBootstrapMethodHandle() {
        return this.bootstrapMethodHandle;
    }

    public Object[] getBootstrapMethodArguments() {
        return this.bootstrapMethodArguments;
    }

    @Override
    public Object invokeInstruction() {
        if ("makeConcatWithConstants".equals(this.name)) {
            String result = this.bootstrapMethodArguments[0].toString();
            List<Class<?>> paramTypes = JobDetailsGeneratorUtils.findParamTypesFromDescriptor(this.descriptor);
            while (result.contains("\u0001") && !paramTypes.isEmpty()) {
                Class<?> paramType = paramTypes.remove(paramTypes.size() - 1);
                Object value = ReflectionUtils.autobox(this.jobDetailsBuilder.getStack().pollLast(), paramType);
                result = InvokeDynamicInstruction.replaceLast(result, "\u0001", value.toString());
            }
            return result;
        }
        throw JobRunrException.shouldNotHappenException("Unknown INVOKEDYNAMIC instruction: " + this.name);
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replacement);
    }
}

