/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jobrunr.jobs.filters.DisplayNameFilter;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.jobs.filters.RetryFilter;
import org.jobrunr.utils.CollectionUtils;

public class JobDefaultFilters {
    private final List<JobFilter> filters;

    public JobDefaultFilters(JobFilter ... filters) {
        this(Arrays.asList(filters));
    }

    public JobDefaultFilters(List<JobFilter> filters) {
        this.filters = this.getAllJobFilters(filters);
    }

    public void addAll(List<? extends JobFilter> filters) {
        if (CollectionUtils.isNullOrEmpty(filters)) {
            return;
        }
        this.filters.addAll(filters);
    }

    List<JobFilter> getFilters() {
        return this.filters;
    }

    private ArrayList<JobFilter> getAllJobFilters(List<JobFilter> jobFilters) {
        ArrayList<JobFilter> result = new ArrayList<JobFilter>(Arrays.asList(new DisplayNameFilter(), new RetryFilter()));
        result.addAll(jobFilters);
        return result;
    }
}

