/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.filters;

import java.time.Instant;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.filters.ElectStateFilter;
import org.jobrunr.jobs.states.FailedState;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.jobs.states.StateName;
import org.jobrunr.utils.JobUtils;

public class RetryFilter
implements ElectStateFilter {
    public static final int DEFAULT_BACKOFF_POLICY_TIME_SEED = 3;
    public static final int DEFAULT_NBR_OF_RETRIES = 10;
    private final int numberOfRetries;
    private final int backOffPolicyTimeSeed;

    public RetryFilter() {
        this(10);
    }

    public RetryFilter(int numberOfRetries) {
        this(numberOfRetries, 3);
    }

    public RetryFilter(int numberOfRetries, int backOffPolicyTimeSeed) {
        this.numberOfRetries = numberOfRetries;
        this.backOffPolicyTimeSeed = backOffPolicyTimeSeed;
    }

    @Override
    public void onStateElection(Job job, JobState newState) {
        if (this.isNotFailed(newState) || this.isProblematicExceptionAndMustNotRetry(newState) || this.maxAmountOfRetriesReached(job)) {
            return;
        }
        job.scheduleAt(Instant.now().plusSeconds(this.getSecondsToAdd(job)), String.format("Retry %d of %d", this.getFailureCount(job), this.getMaxNumberOfRetries(job)));
    }

    protected long getSecondsToAdd(Job job) {
        return this.getExponentialBackoffPolicy(job, this.backOffPolicyTimeSeed);
    }

    protected long getExponentialBackoffPolicy(Job job, int seed) {
        return (long)Math.pow(seed, this.getFailureCount(job));
    }

    private boolean maxAmountOfRetriesReached(Job job) {
        return this.getFailureCount(job) > (long)this.getMaxNumberOfRetries(job);
    }

    private long getFailureCount(Job job) {
        return job.getJobStates().stream().filter(StateName.FAILED_STATES).count();
    }

    private boolean isProblematicExceptionAndMustNotRetry(JobState newState) {
        if (newState instanceof FailedState) {
            return ((FailedState)newState).mustNotRetry();
        }
        return false;
    }

    private boolean isNotFailed(JobState newState) {
        return !(newState instanceof FailedState);
    }

    private int getMaxNumberOfRetries(Job job) {
        return JobUtils.getJobAnnotation(job.getJobDetails()).map(jobAnnotation -> jobAnnotation.retries() > -1 ? Integer.valueOf(jobAnnotation.retries()) : null).orElse(this.numberOfRetries);
    }
}

